/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindTestElementsUpToRootTraverser
implements HashTreeTraverser {
    private static final Logger log = LoggerFactory.getLogger(FindTestElementsUpToRootTraverser.class);
    private final Deque<TestElement> stack = new ArrayDeque<TestElement>();
    private final Object nodeToFind;
    private boolean stopRecording = false;

    public FindTestElementsUpToRootTraverser(Object nodeToFind) {
        this.nodeToFind = nodeToFind;
    }

    @Override
    public void addNode(Object node, HashTree subTree) {
        if (this.stopRecording) {
            return;
        }
        if (node == this.nodeToFind) {
            this.stopRecording = true;
        }
        this.stack.addLast((TestElement)node);
    }

    @Override
    public void subtractNode() {
        if (this.stopRecording) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Subtracting node, stack size = {}", (Object)this.stack.size());
        }
        this.stack.removeLast();
    }

    @Override
    public void processPath() {
    }

    public List<Controller> getControllersToRoot() {
        ArrayList<Controller> result = new ArrayList<Controller>(this.stack.size());
        ArrayDeque<TestElement> stackLocalCopy = new ArrayDeque<TestElement>(this.stack);
        while (!stackLocalCopy.isEmpty()) {
            TestElement te = (TestElement)stackLocalCopy.getLast();
            if (te instanceof Controller) {
                result.add((Controller)te);
            }
            stackLocalCopy.removeLast();
        }
        return result;
    }
}

