/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apiguardian.api.API;

@API(since="5.3", status=API.Status.EXPERIMENTAL)
public class DynamicStyle {
    private final Map<JComponent, List<Consumer<JComponent>>> listeners = new WeakHashMap<JComponent, List<Consumer<JComponent>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public <T extends JComponent> T withDynamic(T component, Consumer<? super T> onUpdateUi) {
        onUpdateUi.accept(component);
        Map<JComponent, List<Consumer<JComponent>>> map = this.listeners;
        synchronized (map) {
            this.listeners.compute(component, (k, v) -> {
                if (v == null) {
                    return Collections.singletonList(onUpdateUi);
                }
                List res = v.size() == 1 ? new ArrayList(v) : v;
                res.add(onUpdateUi);
                return res;
            });
        }
        return component;
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public <T extends JComponent> T withBorder(T component, String resource) {
        return (T)this.withDynamic(component, c -> c.setBorder(UIManager.getBorder(resource)));
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public <T extends JComponent> T withFont(T component, String resource) {
        return (T)this.withDynamic(component, c -> c.setFont(UIManager.getFont(resource)));
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public static Closeable onLaFChange(Runnable action) {
        action.run();
        PropertyChangeListener listener = evt -> {
            if ("lookAndFeel".equals(evt.getPropertyName())) {
                action.run();
            }
        };
        UIManager.addPropertyChangeListener(listener);
        return () -> UIManager.removePropertyChangeListener(listener);
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public void updateLaf() {
        this.updateLaf(UIManager.getLookAndFeel().getClass().getName());
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public void updateLaf(String className) {
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            throw new IllegalStateException("Unable to update look and feel to " + className, e);
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (Window w : Window.getWindows()) {
            this.updateComponentTreeUI(w, components);
            components.clear();
        }
    }

    @API(since="5.3", status=API.Status.EXPERIMENTAL)
    public void updateComponentTreeUI(Component root) {
        this.updateComponentTreeUI(root, new ArrayList<Component>());
    }

    private void updateComponentTreeUI(Component root, List<Component> components) {
        DynamicStyle.collectComponents(root, components);
        for (Component component : components) {
            if (component instanceof JComponent) {
                this.updateComponent((JComponent)component);
            }
            component.invalidate();
        }
        for (Component component : components) {
            component.validate();
        }
        for (Component component : components) {
            component.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateComponent(JComponent component) {
        Map<JComponent, List<Consumer<JComponent>>> map = this.listeners;
        synchronized (map) {
            List<Consumer<JComponent>> list = this.listeners.get(component);
            if (list == null) {
                return;
            }
            for (Consumer<JComponent> action : list) {
                action.accept(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void collectComponents(Component root, List<? super Component> components) {
        Object jpm;
        if (root == null) {
            return;
        }
        components.add(root);
        if (root instanceof JComponent) {
            JComponent jc = (JComponent)root;
            jc.updateUI();
            if (!jc.getInheritsPopupMenu() && (jpm = jc.getComponentPopupMenu()) != null) {
                DynamicStyle.collectComponents((Component)jpm, components);
            }
        }
        Component[] children2 = null;
        if (root instanceof JMenu) {
            jpm = root.getTreeLock();
            synchronized (jpm) {
                children2 = ((JMenu)root).getMenuComponents();
            }
        }
        if (root instanceof Container) {
            jpm = root.getTreeLock();
            synchronized (jpm) {
                children2 = ((Container)root).getComponents();
            }
        }
        if (children2 != null) {
            for (Component child : children2) {
                DynamicStyle.collectComponents(child, components);
            }
        }
        if (root instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)root;
            int size = tabbedPane.getTabCount();
            for (int i = 0; i < size; ++i) {
                DynamicStyle.collectComponents(tabbedPane.getComponentAt(i), components);
                DynamicStyle.collectComponents(tabbedPane.getTabComponentAt(i), components);
            }
        }
    }
}

