/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jorphan.reflect.ClassFilter;
import org.apache.jorphan.reflect.ServiceLoadExceptionHandler;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassFinder {
    private static final Logger log = LoggerFactory.getLogger(ClassFinder.class);
    private static final String DOT_JAR = ".jar";
    private static final String DOT_CLASS = ".class";
    private static final int DOT_CLASS_LEN = ".class".length();
    private static final ThreadLocal<Boolean> SKIP_JARS_WITH_JMETER_SKIP_ATTRIBUTE = new ThreadLocal();
    public static final String JMETER_SKIP_CLASS_SCANNING_ATTRIBUTE = "JMeter-Skip-Class-Scanning";

    private ClassFinder() {
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.6")
    public static boolean getSkipJarsWithJmeterSkipClassScanningAttribute() {
        return Objects.equals(SKIP_JARS_WITH_JMETER_SKIP_ATTRIBUTE.get(), Boolean.TRUE);
    }

    @API(status=API.Status.INTERNAL, since="5.6")
    public static Closeable skipJarsWithJmeterSkipClassScanningAttribute() {
        SKIP_JARS_WITH_JMETER_SKIP_ATTRIBUTE.set(true);
        return SKIP_JARS_WITH_JMETER_SKIP_ATTRIBUTE::remove;
    }

    public static <S> Collection<S> loadServices(Class<S> service, ServiceLoader<S> serviceLoader, ServiceLoadExceptionHandler<? super S> exceptionHandler) {
        ArrayList<S> result = new ArrayList<S>();
        Iterator<S> it = serviceLoader.iterator();
        while (it.hasNext()) {
            try {
                result.add(it.next());
            }
            catch (ServiceConfigurationError e) {
                String message = e.getMessage();
                String className = "";
                if (message.startsWith(service.getName())) {
                    if (message.endsWith(" Unable to get public no-arg constructor")) {
                        className = message.substring(service.getName().length() + ": ".length(), message.length() - " Unable to get public no-arg constructor".length());
                    } else if (message.endsWith(" not a subtype")) {
                        className = message.substring(service.getName().length() + ": ".length(), message.length() - " not a subtype".length());
                    } else if (message.endsWith(" could not be instantiated")) {
                        className = message.substring(service.getName().length() + ": ".length(), message.length() - " could not be instantiated".length());
                    }
                    if (className.startsWith("Provider ")) {
                        className = className.substring("Provider ".length());
                    }
                }
                exceptionHandler.handle(service, className, e);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    @Deprecated
    public static List<String> findClassesThatExtend(String[] paths, Class<?>[] superClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(paths, superClasses, false);
    }

    private static Set<File> addJarsInPath(String[] paths) {
        HashSet<File> fullList = new HashSet<File>();
        for (String path : paths) {
            File[] jars;
            File dir = new File(path);
            fullList.add(dir);
            if (!dir.exists() || !dir.isDirectory() || (jars = dir.listFiles(f -> f.isFile() && f.getName().endsWith(DOT_JAR))) == null) continue;
            Collections.addAll(fullList, jars);
        }
        return fullList;
    }

    @Deprecated
    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, null, null);
    }

    @API(status=API.Status.DEPRECATED, since="5.6")
    @Deprecated
    public static List<String> findClassesThatExtend(String[] strPathsOrJars, Class<?>[] superClasses, boolean innerClasses, String contains, String notContains) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, superClasses, innerClasses, contains, notContains, false);
    }

    @API(status=API.Status.DEPRECATED, since="5.6")
    @Deprecated
    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations, boolean innerClasses) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, innerClasses, null, null, true);
    }

    @API(status=API.Status.DEPRECATED, since="5.6")
    @Deprecated
    public static List<String> findAnnotatedClasses(String[] strPathsOrJars, Class<? extends Annotation>[] annotations) throws IOException {
        return ClassFinder.findClassesThatExtend(strPathsOrJars, annotations, false, null, null, true);
    }

    @API(status=API.Status.DEPRECATED, since="5.6")
    @Deprecated
    public static List<String> findClassesThatExtend(String[] searchPathsOrJars, Class<?>[] classNames, boolean innerClasses, String contains, String notContains, boolean annotations) throws IOException {
        ClassFilter filter;
        if (log.isDebugEnabled()) {
            log.debug("findClassesThatExtend with searchPathsOrJars : {}, superclass : {} innerClasses : {} annotations: {} contains: {}, notContains: {}", Arrays.toString(searchPathsOrJars), Arrays.toString(classNames), innerClasses, annotations, contains, notContains);
        }
        if (annotations) {
            Class<?>[] annoclassNames = classNames;
            filter = new AnnoClassFilter(annoclassNames, innerClasses);
        } else {
            filter = new ExtendsClassFilter(classNames, innerClasses, contains, notContains);
        }
        return ClassFinder.findClasses(searchPathsOrJars, filter);
    }

    @API(status=API.Status.DEPRECATED, since="5.6")
    @Deprecated
    public static List<String> findClasses(String[] searchPathsOrJars, ClassFilter filter) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("findClasses with searchPathsOrJars : {} and classFilter : {}", (Object)Arrays.toString(searchPathsOrJars), (Object)filter);
        }
        Set<File> strPathsOrJars = ClassFinder.addJarsInPath(searchPathsOrJars);
        TreeSet listClasses = new TreeSet();
        for (File path : strPathsOrJars) {
            ClassFinder.findClassesInOnePath(path, listClasses, filter);
        }
        if (log.isDebugEnabled()) {
            log.debug("listClasses.size()={}", (Object)listClasses.size());
            for (String clazz : listClasses) {
                log.debug("listClasses : {}", (Object)clazz);
            }
        }
        return new ArrayList<String>(listClasses);
    }

    private static String fixClassName(String strClassName) {
        String fixedClassName = strClassName.replace('\\', '.');
        fixedClassName = fixedClassName.replace('/', '.');
        fixedClassName = fixedClassName.substring(0, fixedClassName.length() - DOT_CLASS_LEN);
        return fixedClassName;
    }

    private static void findClassesInOnePath(File file, Set<? super String> listClasses, ClassFilter filter) {
        if (file.isDirectory()) {
            ClassFinder.findClassesInPathsDir(file.getAbsolutePath(), file, listClasses, filter);
        } else if (file.exists()) {
            if (ClassFinder.getSkipJarsWithJmeterSkipClassScanningAttribute() && file.getName().endsWith(DOT_JAR)) {
                try (JarFile jar = new JarFile(file);){
                    String value = jar.getManifest().getMainAttributes().getValue(JMETER_SKIP_CLASS_SCANNING_ATTRIBUTE);
                    if (Boolean.parseBoolean(value)) {
                        log.debug("Will skip scanning jar {} with filter {} since the jar has {}={} attribute", file, filter, JMETER_SKIP_CLASS_SCANNING_ATTRIBUTE, value);
                        return;
                    }
                    log.info("Will scan jar {} with filter {}. Consider exposing JMeter plugins via META-INF/services, and add {}=true manifest attribute so JMeter can skip classfile scanning", file, filter, JMETER_SKIP_CLASS_SCANNING_ATTRIBUTE);
                }
                catch (IOException e) {
                    log.warn("Can not open the jar {}, message: {}", file.getAbsolutePath(), e.getLocalizedMessage(), e);
                }
            }
            try (ZipFile zipFile = new ZipFile(file);
                 Stream<? extends ZipEntry> entries = zipFile.stream();){
                entries.filter(entry -> entry.getName().endsWith(DOT_CLASS)).forEach(entry -> {
                    String fixedClassName = ClassFinder.fixClassName(entry.getName());
                    ClassFinder.applyFiltering(listClasses, filter, fixedClassName);
                });
            }
            catch (IOException e) {
                log.warn("Can not open the jar {}, message: {}", file.getAbsolutePath(), e.getLocalizedMessage(), e);
            }
        }
    }

    private static void findClassesInPathsDir(String strPathElement, File dir, Set<? super String> listClasses, ClassFilter filter) {
        File[] list = dir.listFiles();
        if (list == null) {
            log.warn("{} is not a folder", (Object)dir.getAbsolutePath());
            return;
        }
        for (File file : list) {
            if (file.isDirectory()) {
                ClassFinder.findClassesInPathsDir(strPathElement, file, listClasses, filter);
                continue;
            }
            if (!file.getPath().endsWith(DOT_CLASS) || !file.exists() || file.length() == 0L) continue;
            String path = file.getPath();
            String className = path.substring(strPathElement.length() + 1, path.lastIndexOf(46)).replace(File.separator.charAt(0), '.');
            ClassFinder.applyFiltering(listClasses, filter, className);
        }
    }

    private static void applyFiltering(Set<? super String> classesSet, ClassFilter filter, String className) {
        try {
            if (filter.accept(className)) {
                classesSet.add(className);
            }
        }
        catch (Throwable e) {
            log.error("Error filtering class {}, it will be ignored", (Object)className, (Object)e);
        }
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.6")
    public static interface Closeable
    extends AutoCloseable {
        @Override
        public void close();
    }

    private static class AnnoClassFilter
    implements ClassFilter {
        private final boolean inner;
        private final Class<? extends Annotation>[] annotations;
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        AnnoClassFilter(Class<? extends Annotation>[] annotations, boolean inner) {
            this.annotations = annotations;
            this.inner = inner;
        }

        @Override
        public boolean accept(String className) {
            if (!className.contains("$") || this.inner) {
                return AnnoClassFilter.hasAnnotationOnMethod(this.annotations, className, this.contextClassLoader);
            }
            return false;
        }

        private static boolean hasAnnotationOnMethod(Class<? extends Annotation>[] annotations, String classInQuestion, ClassLoader contextClassLoader) {
            try {
                Class<?> c = Class.forName(classInQuestion, false, contextClassLoader);
                return Arrays.stream(c.getMethods()).anyMatch(method -> Arrays.stream(annotations).anyMatch(method::isAnnotationPresent));
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError ignored) {
                log.debug(ignored.getLocalizedMessage(), ignored);
                return false;
            }
        }

        public String toString() {
            return "AnnoClassFilter [inner=" + this.inner + ", annotations=" + (this.annotations != null ? Arrays.toString(this.annotations) : "null") + "]";
        }
    }

    private static class ExtendsClassFilter
    implements ClassFilter {
        private final Class<?>[] parents;
        private final boolean inner;
        private final String contains;
        private final String notContains;
        private final ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();

        ExtendsClassFilter(Class<?>[] parents, boolean inner, String contains, String notContains) {
            this.parents = parents;
            this.inner = inner;
            this.contains = contains;
            this.notContains = notContains;
        }

        @Override
        public boolean accept(String className) {
            if (this.contains != null && !className.contains(this.contains)) {
                return false;
            }
            if (this.notContains != null && className.contains(this.notContains)) {
                return false;
            }
            if (!className.contains("$") || this.inner) {
                return ExtendsClassFilter.isChildOf(this.parents, className, this.contextClassLoader);
            }
            return false;
        }

        private static boolean isChildOf(Class<?>[] parentClasses, String strClassName, ClassLoader contextClassLoader) {
            try {
                Class<?> targetClass = Class.forName(strClassName, false, contextClassLoader);
                if (!targetClass.isInterface() && !Modifier.isAbstract(targetClass.getModifiers())) {
                    return Arrays.stream(parentClasses).anyMatch(parent -> parent.isAssignableFrom(targetClass));
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError | VerifyError e) {
                log.debug(e.getLocalizedMessage(), e);
            }
            return false;
        }

        public String toString() {
            return "ExtendsClassFilter [parents=" + (this.parents != null ? Arrays.toString(this.parents) : "null") + ", inner=" + this.inner + ", contains=" + this.contains + ", notContains=" + this.notContains + "]";
        }
    }
}

