/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ClassUtils;
import org.apache.jorphan.util.JMeterException;

public class ClassTools {
    public static Object construct(String className) throws JMeterException {
        Object instance = null;
        try {
            instance = ClassUtils.getClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new JMeterException(e);
        }
        return instance;
    }

    public static Object construct(String className, int parameter) throws JMeterException {
        Object instance = null;
        try {
            Class<?> clazz = ClassUtils.getClass(className);
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
            instance = constructor.newInstance(parameter);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new JMeterException(e);
        }
        return instance;
    }

    public static Object construct(String className, String parameter) throws JMeterException {
        Object instance = null;
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            instance = constructor.newInstance(parameter);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JMeterException(e);
        }
        return instance;
    }

    public static void invoke(Object instance, String methodName) throws SecurityException, IllegalArgumentException, JMeterException {
        try {
            Method m = ClassUtils.getPublicMethod(instance.getClass(), methodName, new Class[0]);
            m.invoke(instance, (Object[])null);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new JMeterException(e);
        }
    }
}

