/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.RandomStringGenerator;

public final class JOrphanUtils {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private static final char[] SPACES_CHARS = "                                 ".toCharArray();
    private static final int SPACES_LEN = SPACES_CHARS.length;
    private static final byte[] XML_PFX = new byte[]{60, 63, 120, 109, 108};

    private JOrphanUtils() {
    }

    public static String[] split(String splittee, String splitChar, boolean truncate) {
        int spot;
        if (splittee == null || splitChar == null) {
            return new String[0];
        }
        String EMPTY_ELEMENT = "";
        int splitLength = splitChar.length();
        String adjacentSplit = splitChar + splitChar;
        int adjacentSplitLength = adjacentSplit.length();
        if (truncate) {
            while ((spot = splittee.indexOf(adjacentSplit)) != -1) {
                splittee = splittee.substring(0, spot + splitLength) + splittee.substring(spot + adjacentSplitLength, splittee.length());
            }
            if (splittee.startsWith(splitChar)) {
                splittee = splittee.substring(splitLength);
            }
            if (splittee.endsWith(splitChar)) {
                splittee = splittee.substring(0, splittee.length() - splitLength);
            }
        }
        ArrayList<String> returns = new ArrayList<String>();
        int length = splittee.length();
        int start = 0;
        spot = 0;
        while (start < length && (spot = splittee.indexOf(splitChar, start)) > -1) {
            if (spot > 0) {
                returns.add(splittee.substring(start, spot));
            } else {
                returns.add("");
            }
            start = spot + splitLength;
        }
        if (start < length) {
            returns.add(splittee.substring(start));
        } else if (spot == length - splitLength) {
            returns.add("");
        }
        return returns.toArray(new String[returns.size()]);
    }

    public static String[] split(String splittee, String splitChar) {
        return JOrphanUtils.split(splittee, splitChar, true);
    }

    public static String[] split(String splittee, String delims, String def) {
        StringTokenizer tokens = new StringTokenizer(splittee, delims, def != null);
        boolean lastWasDelim = false;
        ArrayList<String> strList = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String tok = tokens.nextToken();
            if (tok.length() == 1 && delims.contains(tok)) {
                if (lastWasDelim) {
                    strList.add(def);
                }
                lastWasDelim = true;
                continue;
            }
            lastWasDelim = false;
            strList.add(tok);
        }
        if (lastWasDelim) {
            strList.add(def);
        }
        return strList.toArray(new String[strList.size()]);
    }

    public static StringBuilder rightAlign(StringBuilder in, int len) {
        int pfx = len - in.length();
        if (pfx <= 0) {
            return in;
        }
        if (pfx > SPACES_LEN) {
            pfx = SPACES_LEN;
        }
        in.insert(0, SPACES_CHARS, 0, pfx);
        return in;
    }

    public static StringBuilder leftAlign(StringBuilder in, int len) {
        int sfx = len - in.length();
        if (sfx <= 0) {
            return in;
        }
        if (sfx > SPACES_LEN) {
            sfx = SPACES_LEN;
        }
        in.append(SPACES_CHARS, 0, sfx);
        return in;
    }

    public static String booleanToSTRING(boolean value) {
        return value ? "TRUE" : "FALSE";
    }

    public static String replaceFirst(String source2, String search, String replace) {
        int start = source2.indexOf(search);
        int len = search.length();
        if (start == -1) {
            return source2;
        }
        if (start == 0) {
            return replace + source2.substring(len);
        }
        return source2.substring(0, start) + replace + source2.substring(start + len);
    }

    public static String replaceAllChars(String source2, char search, String replace) {
        int indexOf = source2.indexOf(search);
        if (indexOf == -1) {
            return source2;
        }
        int offset = 0;
        char[] chars = source2.toCharArray();
        StringBuilder sb = new StringBuilder(source2.length() + 20);
        while (indexOf != -1) {
            sb.append(chars, offset, indexOf - offset);
            sb.append(replace);
            offset = indexOf + 1;
            indexOf = source2.indexOf(search, offset);
        }
        sb.append(chars, offset, chars.length - offset);
        return sb.toString();
    }

    public static String substitute(String input, String pattern, String sub) {
        StringBuilder ret = new StringBuilder(input.length());
        int start = 0;
        int index = -1;
        int length = pattern.length();
        while ((index = input.indexOf(pattern, start)) >= start) {
            ret.append(input.substring(start, index));
            ret.append(sub);
            start = index + length;
        }
        ret.append(input.substring(start));
        return ret.toString();
    }

    public static String trim(String input, String delims) {
        StringTokenizer tokens = new StringTokenizer(input, delims);
        return tokens.hasMoreTokens() ? tokens.nextToken() : "";
    }

    public static byte[] getByteArraySlice(byte[] array, int begin, int end) {
        byte[] slice = new byte[end - begin + 1];
        System.arraycopy(array, begin, slice, 0, slice.length);
        return slice;
    }

    public static void closeQuietly(Closeable cl) {
        try {
            if (cl != null) {
                cl.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket sock) {
        try {
            if (sock != null) {
                sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ServerSocket sock) {
        try {
            if (sock != null) {
                sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean startsWith(byte[] target, byte[] search, int offset) {
        int targetLength = target.length;
        int searchLength = search.length;
        if (offset < 0 || searchLength > targetLength + offset) {
            return false;
        }
        for (int i = 0; i < searchLength; ++i) {
            if (target[i + offset] == search[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean isXML(byte[] target) {
        return JOrphanUtils.startsWith(target, XML_PFX, 0);
    }

    public static String baToHexString(byte[] ba) {
        StringBuilder sb = new StringBuilder(ba.length * 2);
        for (byte b : ba) {
            int j = b & 0xFF;
            if (j < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(j));
        }
        return sb.toString();
    }

    public static String baToHexString(byte[] ba, char separator) {
        StringBuilder sb = new StringBuilder(ba.length * 2);
        for (int i = 0; i < ba.length; ++i) {
            int j;
            if (i > 0 && separator != '\u0000') {
                sb.append(separator);
            }
            if ((j = ba[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(j));
        }
        return sb.toString();
    }

    public static byte[] baToHexBytes(byte[] ba) {
        byte[] hb = new byte[ba.length * 2];
        for (int i = 0; i < ba.length; ++i) {
            byte upper = (byte)((ba[i] & 0xF0) >> 4);
            byte lower = (byte)(ba[i] & 0xF);
            hb[2 * i] = JOrphanUtils.toHexChar(upper);
            hb[2 * i + 1] = JOrphanUtils.toHexChar(lower);
        }
        return hb;
    }

    private static byte toHexChar(byte in) {
        if (in < 10) {
            return (byte)(in + 48);
        }
        return (byte)(in - 10 + 97);
    }

    public static int read(InputStream is, byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count;
        for (remaining = length; remaining > 0 && -1 != (count = is.read(buffer, location = length - remaining, remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static void displayThreads(boolean includeDaemons) {
        Map<Thread, StackTraceElement[]> m = Thread.getAllStackTraces();
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> e : m.entrySet()) {
            StackTraceElement[] ste;
            boolean daemon = e.getKey().isDaemon();
            if (!includeDaemons && daemon) continue;
            builder.setLength(0);
            builder.append(e.getKey());
            if (daemon) {
                builder.append(" (daemon)");
            }
            builder.append(lineSeparator);
            for (StackTraceElement stackTraceElement : ste = e.getValue()) {
                builder.append("  at ").append(stackTraceElement).append(lineSeparator);
            }
            System.out.println(builder);
        }
    }

    public static String nullifyIfEmptyTrimmed(String input) {
        if (input == null) {
            return null;
        }
        String trimmed = input.trim();
        if (trimmed.length() == 0) {
            return null;
        }
        return trimmed;
    }

    public static boolean isBlank(String value) {
        return StringUtils.isBlank(value);
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        int bytes = data.length;
        int offset = 0;
        while (bytes > 0) {
            int chunk = Math.min(bytes, 4096);
            output.write(data, offset, chunk);
            bytes -= chunk;
            offset += chunk;
        }
    }

    public static String formatDuration(long elapsedSec) {
        return String.format("%02d:%02d:%02d", elapsedSec / 3600L, elapsedSec % 3600L / 60L, elapsedSec % 60L);
    }

    public static void canSafelyWriteToFolder(File folder) {
        JOrphanUtils.canSafelyWriteToFolder(folder, false, file -> true);
    }

    public static void canSafelyWriteToFolder(File folder, FileFilter fileFilter) {
        JOrphanUtils.canSafelyWriteToFolder(folder, false, fileFilter);
    }

    public static void canSafelyWriteToFolder(File folder, boolean deleteFolderContent) {
        JOrphanUtils.canSafelyWriteToFolder(folder, deleteFolderContent, file -> true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void canSafelyWriteToFolder(File folder, boolean deleteFolderIfExists, FileFilter exporterFileFilter) {
        if (folder.exists()) {
            if (folder.isFile()) {
                if (!deleteFolderIfExists) throw new IllegalArgumentException("Cannot write to '" + folder.getAbsolutePath() + "' as it is an existing file");
                if (folder.delete()) return;
                throw new IllegalArgumentException("Cannot write to '" + folder.getAbsolutePath() + "' as it is an existing file and delete failed");
            }
            File[] listedFiles = folder.listFiles(exporterFileFilter);
            if (listedFiles == null || listedFiles.length <= 0) return;
            if (!deleteFolderIfExists) throw new IllegalArgumentException("Cannot write to '" + folder.getAbsolutePath() + "' as folder is not empty");
            try {
                FileUtils.deleteDirectory(folder);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Cannot write to '" + folder.getAbsolutePath() + "' as folder is not empty and cleanup failed with error:" + ex.getMessage(), ex);
            }
            if (folder.mkdir()) return;
            throw new IllegalArgumentException("Cannot create folder " + folder.getAbsolutePath());
        }
        if (folder.getAbsoluteFile().getParentFile().canWrite()) return;
        throw new IllegalArgumentException("Cannot write to '" + folder.getAbsolutePath() + "' as folder does not exist and parent folder is not writable");
    }

    public static Object[] replaceAllWithRegex(String source2, String regex, String replacement, boolean caseSensitive) {
        Pattern pattern = caseSensitive ? Pattern.compile(regex) : Pattern.compile(regex, 2);
        String replacementQuoted = Matcher.quoteReplacement(replacement);
        Matcher matcher = pattern.matcher(source2);
        int totalReplaced = 0;
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(result, replacementQuoted);
            ++totalReplaced;
        }
        matcher.appendTail(result);
        return new Object[]{result.toString(), totalReplaced};
    }

    public static int replaceValue(String regex, String replaceBy, boolean caseSensitive, String value, Consumer<? super String> setter) {
        if (StringUtils.isBlank(value)) {
            return 0;
        }
        Object[] result = JOrphanUtils.replaceAllWithRegex(value, regex, replaceBy, caseSensitive);
        int nbReplaced = (Integer)result[1];
        if (nbReplaced <= 0) {
            return 0;
        }
        setter.accept((String)result[0]);
        return nbReplaced;
    }

    public static String unsplit(Object[] splittee, Object splitChar) {
        StringBuilder retVal = new StringBuilder();
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            }
            if (count + 1 >= splittee.length || splittee[count + 1] == null) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String generateRandomAlphanumericPassword(int length) {
        char[][] pairs = new char[][]{{'a', 'z'}, {'A', 'Z'}, {'0', '9'}};
        RandomStringGenerator pwdGenerator = new RandomStringGenerator.Builder().usingRandom(LazySecureRandom.INSTANCE::nextInt).withinRange(pairs).build();
        return pwdGenerator.generate(length);
    }

    private static class LazySecureRandom {
        private static final SecureRandom INSTANCE = new SecureRandom();

        private LazySecureRandom() {
        }
    }
}

