/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.assertions;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class BinaryContentAssertionGuiPanel
extends JPanel {
    JTextArea binaryContent;
    JRadioButton containsButton;
    JRadioButton doesButton;
    JRadioButton doesNotButton;
    JRadioButton equalsButton;
    JRadioButton startsWithButton;

    public BinaryContentAssertionGuiPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BoxLayout(settingsPanel, 0));
        settingsPanel.add(Box.createHorizontalStrut(5));
        settingsPanel.add(new JLabel("Assert response "));
        JPanel negationPanel = new JPanel();
        negationPanel.setLayout(new BoxLayout(negationPanel, 1));
        negationPanel.add(Box.createVerticalGlue());
        this.doesButton = new JRadioButton("does");
        negationPanel.add(this.doesButton);
        this.doesNotButton = new JRadioButton("does NOT");
        negationPanel.add(this.doesNotButton);
        ButtonGroup negationGroup = new ButtonGroup();
        this.doesButton.setSelected(true);
        negationGroup.add(this.doesButton);
        negationGroup.add(this.doesNotButton);
        negationPanel.add(Box.createVerticalGlue());
        negationPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0), BorderFactory.createEtchedBorder()));
        settingsPanel.add(negationPanel);
        JPanel matchPanel = new JPanel();
        matchPanel.setLayout(new BoxLayout(matchPanel, 1));
        this.containsButton = new JRadioButton("contain");
        matchPanel.add(this.containsButton);
        this.startsWithButton = new JRadioButton("start with");
        matchPanel.add(this.startsWithButton);
        this.equalsButton = new JRadioButton("equal");
        matchPanel.add(this.equalsButton);
        this.containsButton.setSelected(true);
        ButtonGroup matchGroup = new ButtonGroup();
        matchGroup.add(this.containsButton);
        matchGroup.add(this.equalsButton);
        matchGroup.add(this.startsWithButton);
        matchPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5), BorderFactory.createEtchedBorder()));
        settingsPanel.add(matchPanel);
        settingsPanel.add(new JLabel("the following binary data:"));
        settingsPanel.setAlignmentX(0.0f);
        this.add(settingsPanel);
        JSplitPane splitter = new JSplitPane(0);
        JPanel borderPanel = new JPanel();
        borderPanel.setBorder(BorderFactory.createTitledBorder(null, "Binary data", 1, 0));
        borderPanel.setLayout(new BorderLayout());
        this.binaryContent = new JTextArea();
        this.binaryContent.setRows(5);
        borderPanel.add(this.binaryContent);
        splitter.setBorder(null);
        splitter.setTopComponent(borderPanel);
        splitter.setBottomComponent(new JPanel());
        splitter.setAlignmentX(0.0f);
        this.add(splitter);
    }

    void clearGui() {
        this.binaryContent.setText("");
        this.setDoes(true);
        this.setContains();
    }

    public void setDoes(boolean value) {
        this.doesButton.setSelected(value);
        this.doesNotButton.setSelected(!value);
    }

    public void setContains() {
        this.containsButton.setSelected(true);
        this.equalsButton.setSelected(false);
        this.startsWithButton.setSelected(false);
    }

    public void setEquals() {
        this.containsButton.setSelected(false);
        this.equalsButton.setSelected(true);
        this.startsWithButton.setSelected(false);
    }

    public void setStartsWith() {
        this.containsButton.setSelected(false);
        this.equalsButton.setSelected(false);
        this.startsWithButton.setSelected(true);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 400);
        frame.getContentPane().add(new BinaryContentAssertionGuiPanel());
        frame.setVisible(true);
    }
}

