/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import java.awt.CardLayout;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class AboutDialog
extends JDialog {
    private static final String DOWNLOAD_API_URL = "https://api.bitbucket.org/2.0/repositories/pjtr/jmeter-websocket-samplers/downloads";
    private static final String DOWNLOAD_URL = "https://bitbucket.org/pjtr/jmeter-websocket-samplers/downloads";
    private static final String DOC_URL = "https://github.com/Luminis-Arnhem/jmeter-websocket-samplers/blob/master/README.md";
    private static final String FAQ_URL = "https://github.com/Luminis-Arnhem/jmeter-websocket-samplers/blob/master/FAQ.md";
    private static AboutDialog aboutDlg;
    private SwingWorker<String, Object> worker;
    private JLabel newVersionLabel;

    public AboutDialog(Window parent) {
        super(parent, "About WebSocket Samplers");
        this.setResizable(false);
        final CardLayout cardLayoutMgr = new CardLayout();
        final JPanel cards = new JPanel();
        final JProgressBar progress = new JProgressBar();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(10, 10, 5, 10))));
        JLabel versionMessage = new JLabel("WebSocket Samplers plugin, version " + (this.getVersion() != null ? this.getVersion() : "unknown") + ".");
        versionMessage.setAlignmentX(0.0f);
        panel.add(versionMessage);
        panel.add(Box.createVerticalStrut(5));
        JPanel docsPanel = new JPanel(new FlowLayout(0, 0, 0));
        docsPanel.setAlignmentX(0.0f);
        JLabel docsLabel = new JLabel("<html>For documentation, see the <a href=\"https://github.com/Luminis-Arnhem/jmeter-websocket-samplers/blob/master/README.md\">README</a> </html>");
        this.makeClickGoto(docsLabel, DOC_URL);
        docsPanel.add(docsLabel);
        JLabel faqLabel = new JLabel("<html>&nbsp;and <a href=\"https://github.com/Luminis-Arnhem/jmeter-websocket-samplers/blob/master/FAQ.md\">FAQ</a>.</html>");
        this.makeClickGoto(faqLabel, FAQ_URL);
        docsPanel.add(faqLabel);
        panel.add(docsPanel);
        cards.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        cards.setLayout(cardLayoutMgr);
        JPanel card1 = new JPanel();
        card1.setLayout(new BoxLayout(card1, 1));
        JLabel updateLabel = new JLabel("Checking for updates...");
        updateLabel.setAlignmentX(0.0f);
        card1.add(updateLabel);
        card1.add(Box.createVerticalStrut(5));
        progress.setIndeterminate(true);
        progress.setAlignmentX(0.0f);
        card1.add(progress);
        cards.add(card1);
        JPanel card2 = new JPanel();
        card2.setLayout(new BoxLayout(card2, 1));
        this.newVersionLabel = new JLabel("There is a newer version available ().");
        this.newVersionLabel.setAlignmentX(0.0f);
        card2.add(this.newVersionLabel);
        card2.add(Box.createVerticalStrut(5));
        card2.add(new JLabel("Download it from:"));
        JLabel downloadLabel = new JLabel("<html> <a href=\"https://bitbucket.org/pjtr/jmeter-websocket-samplers/downloads\">https://bitbucket.org/pjtr/jmeter-websocket-samplers/downloads</a>.</html>");
        this.makeClickGoto(downloadLabel, DOWNLOAD_URL);
        card2.add(downloadLabel);
        cards.add(card2);
        cards.add(new JLabel("An error occurred; could not determine whether there are any updates."));
        JPanel card4 = new JPanel();
        card4.setLayout(new BoxLayout(card4, 1));
        card4.add(new JLabel("No update available; you have the latest version."));
        card4.add(Box.createVerticalStrut(10));
        cards.add(card4);
        panel.add(cards);
        cards.setAlignmentX(0.0f);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1, 0, 0));
        JButton okButton = new JButton("OK");
        buttonPanel.add(okButton);
        okButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        panel.add(buttonPanel);
        buttonPanel.setAlignmentX(0.0f);
        this.add(panel);
        this.worker = new SwingWorker<String, Object>(){

            @Override
            protected void done() {
                try {
                    progress.setIndeterminate(false);
                    progress.setValue(progress.getMaximum());
                    if (!this.isCancelled()) {
                        AboutDialog.this.newVersionLabel.setText(AboutDialog.this.newVersionLabel.getText().replace("()", "(" + (String)this.get() + ")"));
                        if (this.get() != null) {
                            cardLayoutMgr.next(cards);
                        } else {
                            cardLayoutMgr.last(cards);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException e) {
                    cardLayoutMgr.next(cards);
                    cardLayoutMgr.next(cards);
                }
            }

            @Override
            protected String doInBackground() throws Exception {
                return AboutDialog.this.checkForUpdate();
            }
        };
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                AboutDialog.this.worker.execute();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                progress.setValue(progress.getMaximum());
                AboutDialog.this.worker.cancel(true);
            }
        });
    }

    String checkForUpdate() throws CannotDetermineUpdateException {
        String string;
        URL downloads = new URL(DOWNLOAD_API_URL);
        BufferedReader reader = new BufferedReader(new InputStreamReader(downloads.openStream()));
        try {
            string = AboutDialog.getHigherVersion(reader.readLine(), this.getVersion());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception error) {
                throw new CannotDetermineUpdateException();
            }
        }
        reader.close();
        return string;
    }

    String getVersion() {
        InputStream in = this.getClass().getResourceAsStream("version.properties");
        if (in != null) {
            String string;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                string = reader.readLine();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            reader.close();
            return string;
        }
        return null;
    }

    void makeClickGoto(JLabel label, final String url) {
        label.setCursor(new Cursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        });
    }

    static String getHigherVersion(String content, String current) throws CannotDetermineUpdateException {
        if (current == null) {
            throw new IllegalArgumentException("current version is unknown");
        }
        Matcher m = Pattern.compile("((\\d+)\\.(\\d+)(\\.(\\d+))?)").matcher(current);
        if (!m.find()) {
            throw new IllegalArgumentException("current version cannt be parsed");
        }
        int currentVersion = Integer.parseInt(m.group(2)) * 1000000 + Integer.parseInt(m.group(3)) * 1000;
        if (m.group(5) != null) {
            currentVersion += Integer.parseInt(m.group(5));
        }
        int higherVersion = 0;
        m = Pattern.compile("-((\\d+)\\.(\\d+)(\\.(\\d+))?)\\.jar").matcher(content);
        while (m.find()) {
            int version = Integer.parseInt(m.group(2)) * 1000000 + Integer.parseInt(m.group(3)) * 1000;
            if (m.group(5) != null) {
                version += Integer.parseInt(m.group(5));
            }
            if (version <= higherVersion) continue;
            higherVersion = version;
        }
        if (higherVersion > 0 && higherVersion > currentVersion) {
            String result = higherVersion / 1000000 + "." + higherVersion % 1000000 / 1000;
            if (higherVersion % 1000 > 0) {
                result = result + "." + higherVersion % 1000;
            }
            return result;
        }
        if (higherVersion > 0) {
            return null;
        }
        throw new CannotDetermineUpdateException();
    }

    public static void showDialog(Window parent) {
        if (aboutDlg == null) {
            aboutDlg = new AboutDialog(parent);
            aboutDlg.setDefaultCloseOperation(2);
            aboutDlg.pack();
            aboutDlg.setLocationRelativeTo(parent);
            aboutDlg.setVisible(true);
            aboutDlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    aboutDlg = null;
                }
            });
        } else {
            AboutDialog dlg = aboutDlg;
            if (dlg != null) {
                dlg.toFront();
            }
        }
    }

    public static void main(String[] args) {
        AboutDialog.showDialog(null);
    }

    static class CannotDetermineUpdateException
    extends Exception {
        CannotDetermineUpdateException() {
        }
    }
}

