/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.BinaryUtils;
import eu.luminis.jmeter.wssampler.ComparisonType;
import eu.luminis.jmeter.wssampler.DynamicTitledBorder;
import eu.luminis.jmeter.wssampler.GuiUtils;
import eu.luminis.jmeter.wssampler.JMeterUtils;
import eu.luminis.jmeter.wssampler.WebSocketSamplerGuiPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BinaryFrameFilterGuiPanel
extends JPanel {
    private JPanel matchDataPanel;
    private DynamicTitledBorder matchPanelBorder;
    private JLabel matchPositionLabel;
    JTextArea binaryContent;
    JTextField matchPosition;
    private JComboBox typeSelector1;
    private JComboBox typeSelector2;
    JLabel binaryDataLabel;

    public BinaryFrameFilterGuiPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JSplitPane splitter = new JSplitPane(0);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Frame filter condition"), BorderFactory.createEmptyBorder(1, 5, 1, 1)));
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new FlowLayout(0));
        settingsPanel.add(new JLabel("Discard any binary frame"));
        this.typeSelector1 = new JComboBox<String>(new String[]{"", "that", "that does NOT"});
        settingsPanel.add(this.typeSelector1);
        this.typeSelector2 = new JComboBox();
        this.typeSelector2.setPrototypeDisplayValue("starts with");
        settingsPanel.add(this.typeSelector2);
        this.binaryDataLabel = new JLabel("the following binary data:");
        this.binaryDataLabel.setEnabled(false);
        settingsPanel.add(this.binaryDataLabel);
        contentPanel.add(settingsPanel);
        settingsPanel.setAlignmentX(0.0f);
        this.matchDataPanel = new JPanel();
        this.matchPanelBorder = new DynamicTitledBorder(null, "Binary data", 1, 0);
        this.matchDataPanel.setBorder(BorderFactory.createCompoundBorder(this.matchPanelBorder, new EmptyBorder(5, 5, 5, 5)));
        this.matchDataPanel.setLayout(new BorderLayout());
        this.binaryContent = new JTextArea();
        this.binaryContent.setRows(5);
        this.binaryContent.setEnabled(false);
        this.matchPanelBorder.setEnabled(false);
        this.matchDataPanel.add(this.binaryContent);
        contentPanel.add(this.matchDataPanel);
        this.matchDataPanel.setAlignmentX(0.0f);
        JPanel matchPositionPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.matchPositionLabel = new JLabel("starting at position ");
        matchPositionPanel.add(this.matchPositionLabel);
        this.matchPosition = new JTextField();
        this.matchPosition.setColumns(10);
        matchPositionPanel.add(this.matchPosition);
        contentPanel.add(matchPositionPanel);
        matchPositionPanel.setAlignmentX(0.0f);
        splitter.setBorder(null);
        splitter.setTopComponent(contentPanel);
        splitter.setBottomComponent(WebSocketSamplerGuiPanel.createAboutPanel(this));
        splitter.setAlignmentX(0.0f);
        this.add(splitter);
        this.typeSelector1.addActionListener(e -> {
            int selectedItem = this.typeSelector2.getSelectedIndex();
            this.typeSelector2.removeAllItems();
            switch (this.typeSelector1.getSelectedIndex()) {
                case 0: {
                    this.typeSelector2.addItem("");
                    this.binaryDataLabel.setEnabled(false);
                    this.binaryContent.setEnabled(false);
                    this.matchPanelBorder.setEnabled(false);
                    this.matchPosition.setEnabled(false);
                    this.matchPositionLabel.setEnabled(false);
                    this.matchDataPanel.repaint();
                    break;
                }
                case 1: {
                    this.typeSelector2.addItem("contains");
                    this.typeSelector2.addItem("starts with");
                    this.typeSelector2.addItem("equals");
                    this.typeSelector2.addItem("ends with");
                    if (selectedItem >= 0) {
                        this.typeSelector2.setSelectedIndex(selectedItem);
                    }
                    this.binaryDataLabel.setEnabled(true);
                    this.binaryContent.setEnabled(true);
                    this.matchPanelBorder.setEnabled(true);
                    this.matchPosition.setEnabled(this.typeSelector2.getSelectedIndex() == 0);
                    this.matchPositionLabel.setEnabled(this.typeSelector2.getSelectedIndex() == 0);
                    this.matchDataPanel.repaint();
                    break;
                }
                case 2: {
                    this.typeSelector2.addItem("contain");
                    this.typeSelector2.addItem("start with");
                    this.typeSelector2.addItem("equal");
                    this.typeSelector2.addItem("end with");
                    if (selectedItem >= 0) {
                        this.typeSelector2.setSelectedIndex(selectedItem);
                    }
                    this.binaryDataLabel.setEnabled(true);
                    this.binaryContent.setEnabled(true);
                    this.matchPanelBorder.setEnabled(true);
                    this.matchPosition.setEnabled(this.typeSelector2.getSelectedIndex() == 0);
                    this.matchPositionLabel.setEnabled(this.typeSelector2.getSelectedIndex() == 0);
                    this.matchDataPanel.repaint();
                }
            }
        });
        this.typeSelector2.addActionListener(e -> {
            boolean enableMatchPosition = this.typeSelector2.getSelectedIndex() == 0;
            this.matchPosition.setEnabled(enableMatchPosition);
            this.matchPositionLabel.setEnabled(enableMatchPosition);
        });
        this.binaryContent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                BinaryFrameFilterGuiPanel.this.checkContentIsBinary();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                BinaryFrameFilterGuiPanel.this.checkContentIsBinary();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                BinaryFrameFilterGuiPanel.this.checkContentIsBinary();
            }
        });
    }

    ComparisonType getComparisonType() {
        int code = 10 * this.typeSelector1.getSelectedIndex() + this.typeSelector2.getSelectedIndex();
        switch (code) {
            case 0: {
                return ComparisonType.IsPlain;
            }
            case 10: {
                return ComparisonType.Contains;
            }
            case 11: {
                return ComparisonType.StartsWith;
            }
            case 12: {
                return ComparisonType.Equals;
            }
            case 13: {
                return ComparisonType.EndsWith;
            }
            case 20: {
                return ComparisonType.NotContains;
            }
            case 21: {
                return ComparisonType.NotStartsWith;
            }
            case 22: {
                return ComparisonType.NotEquals;
            }
            case 23: {
                return ComparisonType.NotEndsWith;
            }
        }
        throw new RuntimeException("invalid comparison type");
    }

    void setComparisonType(ComparisonType type) {
        switch (type) {
            case IsPlain: {
                this.typeSelector1.setSelectedIndex(0);
                break;
            }
            case Contains: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(0);
                break;
            }
            case StartsWith: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(1);
                break;
            }
            case Equals: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(2);
                break;
            }
            case EndsWith: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(3);
                break;
            }
            case NotContains: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(0);
                break;
            }
            case NotStartsWith: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(1);
                break;
            }
            case NotEquals: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(2);
                break;
            }
            case NotEndsWith: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(3);
                break;
            }
            default: {
                throw new RuntimeException("invalid comparison type");
            }
        }
    }

    private void checkContentIsBinary() {
        try {
            BinaryUtils.parseBinaryString(JMeterUtils.stripJMeterVariables(this.binaryContent.getText()));
            this.binaryContent.setForeground(GuiUtils.getLookAndFeelColor("TextArea.foreground"));
        }
        catch (NumberFormatException notNumber) {
            this.binaryContent.setForeground(GuiUtils.getLookAndFeelColor("TextArea.errorForeground"));
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(800, 400);
        frame.setLocation(new Point(400, 400));
        frame.getContentPane().add(new BinaryFrameFilterGuiPanel());
        frame.setVisible(true);
    }
}

