/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.CloseWebSocketSampler;
import eu.luminis.jmeter.wssampler.JErrorMessageLabel;
import eu.luminis.jmeter.wssampler.WebSocketSamplerGuiPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;

public class CloseWebSocketSamplerGui
extends AbstractSamplerGui {
    private JTextField closeStatusField;
    private JTextField readTimeoutField;

    public CloseWebSocketSamplerGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        WebSocketSamplerGuiPanel layoutPanel = new WebSocketSamplerGuiPanel(){};
        layoutPanel.setLayout(new BorderLayout());
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BoxLayout(settingsPanel, 1));
        settingsPanel.setBorder(BorderFactory.createTitledBorder("Data (close frame)"));
        JPanel closeStatusPanel = new JPanel(new FlowLayout(0));
        closeStatusPanel.add(new JLabel("Close status: "));
        this.closeStatusField = new JTextField();
        this.closeStatusField.setColumns(10);
        closeStatusPanel.add(this.closeStatusField);
        JErrorMessageLabel closeStatusErrorField = new JErrorMessageLabel();
        closeStatusPanel.add(closeStatusErrorField);
        layoutPanel.addIntegerRangeCheck(this.closeStatusField, 1000, 4999, closeStatusErrorField);
        settingsPanel.add(closeStatusPanel);
        JPanel readTimeoutPanel = new JPanel(new FlowLayout(0));
        readTimeoutPanel.add(new JLabel("Response (read) timeout (ms): "));
        this.readTimeoutField = new JTextField();
        this.readTimeoutField.setColumns(10);
        readTimeoutPanel.add(this.readTimeoutField);
        JErrorMessageLabel readTimeoutErrorField = new JErrorMessageLabel();
        readTimeoutPanel.add(readTimeoutErrorField);
        layoutPanel.addIntegerRangeCheck(this.readTimeoutField, 0, 9999999, readTimeoutErrorField);
        settingsPanel.add(readTimeoutPanel);
        layoutPanel.add((Component)settingsPanel, "North");
        layoutPanel.add(WebSocketSamplerGuiPanel.createAboutPanel((JComponent)((Object)this)));
        this.add(layoutPanel, "Center");
    }

    public String getStaticLabel() {
        return "WebSocket Close";
    }

    public String getLabelResource() {
        return null;
    }

    public void clearGui() {
        super.clearGui();
        this.closeStatusField.setText("");
        this.readTimeoutField.setText("");
    }

    public TestElement createTestElement() {
        CloseWebSocketSampler element = new CloseWebSocketSampler();
        this.configureTestElement((TestElement)element);
        return element;
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof CloseWebSocketSampler) {
            CloseWebSocketSampler sampler = (CloseWebSocketSampler)element;
            this.closeStatusField.setText(sampler.getStatusCode());
            this.readTimeoutField.setText(sampler.getReadTimeout());
        }
        super.configure(element);
    }

    public void modifyTestElement(TestElement testElement) {
        this.configureTestElement(testElement);
        if (testElement instanceof CloseWebSocketSampler) {
            CloseWebSocketSampler sampler = (CloseWebSocketSampler)testElement;
            sampler.setStatusCode(this.closeStatusField.getText());
            sampler.setReadTimeout(this.readTimeoutField.getText());
        }
    }
}

