/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.websocket.BinaryFrame;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.TextFrame;
import eu.luminis.websocket.WebSocketClient;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.log.Logger;

public abstract class FrameFilter
extends ConfigTestElement {
    public static final String RESULT_SIZE_INCLUDES_FILTERED_FRAMES = "websocket.result.size_includes_filtered_frames";
    private static boolean includeFilteredFramesInSize;

    public Frame receiveFrame(WebSocketClient wsClient, int readTimeout, SampleResult result) throws IOException {
        return this.receiveFrame(Collections.emptyList(), wsClient, readTimeout, result);
    }

    public Frame receiveFrame(List<FrameFilter> filterList, WebSocketClient wsClient, int readTimeout, SampleResult result) throws IOException {
        Frame receivedFrame;
        boolean matchesFilter;
        this.prepareFilter();
        int socketTimeout = readTimeout;
        do {
            SampleResult subResult = new SampleResult();
            subResult.sampleStart();
            long start = System.currentTimeMillis();
            receivedFrame = !filterList.isEmpty() ? filterList.get(0).receiveFrame(filterList.subList(1, filterList.size()), wsClient, socketTimeout, result) : wsClient.receiveFrame(socketTimeout);
            long timeSpent = System.currentTimeMillis() - start;
            matchesFilter = this.matchesFilter(receivedFrame);
            if (matchesFilter) {
                subResult.sampleEnd();
                this.getLogger().debug("Filter discards " + receivedFrame);
                Frame sentFrame = this.performReplyAction(wsClient, receivedFrame);
                subResult.setSampleLabel("Discarded " + receivedFrame.getTypeAsString() + " frame (by filter '" + this.getName() + "')");
                subResult.setSuccessful(true);
                subResult.setResponseMessage("Received " + receivedFrame);
                subResult.setHeadersSize(receivedFrame.getSize() - receivedFrame.getPayloadSize());
                subResult.setBodySize(receivedFrame.getPayloadSize());
                if (sentFrame != null) {
                    subResult.setSentBytes((long)sentFrame.getSize());
                }
                if (includeFilteredFramesInSize) {
                    result.setHeadersSize(result.getHeadersSize() + receivedFrame.getSize() - receivedFrame.getPayloadSize());
                    result.setBodySize(result.getBodySize() + receivedFrame.getPayloadSize());
                    if (sentFrame != null) {
                        result.setSentBytes(result.getSentBytes() + (long)sentFrame.getSize());
                    }
                }
                if (receivedFrame.isText()) {
                    subResult.setResponseData(((TextFrame)receivedFrame).getText(), null);
                } else if (receivedFrame.isBinary()) {
                    subResult.setResponseData(((BinaryFrame)receivedFrame).getBinaryData());
                }
                result.addRawSubResult(subResult);
            }
            if (timeSpent >= (long)socketTimeout) {
                throw new SocketTimeoutException("Read timed out");
            }
            socketTimeout = (int)((long)socketTimeout - timeSpent);
        } while (matchesFilter);
        return receivedFrame;
    }

    protected void prepareFilter() {
    }

    protected abstract boolean matchesFilter(Frame var1);

    protected Frame performReplyAction(WebSocketClient wsClient, Frame receivedFrame) throws IOException {
        return null;
    }

    public boolean expectsModification() {
        return false;
    }

    protected abstract Logger getLogger();

    public String toString() {
        return "Frame Filter '" + this.getName() + "'";
    }

    static void initStaticFilterOptions() {
        includeFilteredFramesInSize = Boolean.parseBoolean(JMeterUtils.getPropDefault((String)RESULT_SIZE_INCLUDES_FILTERED_FRAMES, (String)"false"));
    }

    static {
        FrameFilter.initStaticFilterOptions();
    }
}

