/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.DataPayloadType;
import eu.luminis.jmeter.wssampler.SamplingAbortedException;
import eu.luminis.jmeter.wssampler.WebsocketSampler;
import eu.luminis.websocket.BinaryFrame;
import eu.luminis.websocket.DataFrame;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.TextFrame;
import eu.luminis.websocket.UnexpectedFrameException;
import eu.luminis.websocket.WebSocketClient;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SingleReadWebSocketSampler
extends WebsocketSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public SingleReadWebSocketSampler() {
        super.setName("Read WebSocket Sampler");
    }

    @Override
    protected WebSocketClient prepareWebSocketClient(SampleResult result) {
        if (this.getCreateNewConnection()) {
            this.dispose((WebSocketClient)threadLocalCachedConnection.get());
            try {
                URL url = new URL(this.getTLS() ? "https" : "http", this.getServer(), Integer.parseInt(this.getPort()), this.getPath());
                return new WebSocketClient(url);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException();
            }
        }
        WebSocketClient wsClient = (WebSocketClient)threadLocalCachedConnection.get();
        if (wsClient != null) {
            return wsClient;
        }
        log.error("Sampler '" + this.getName() + "': there is no connection to re-use");
        result.setResponseCode("Sampler error");
        result.setResponseMessage("Sampler configured for using existing connection, but there is no connection");
        return null;
    }

    @Override
    protected Frame doSample(WebSocketClient wsClient, SampleResult result) throws IOException, UnexpectedFrameException, SamplingAbortedException {
        try {
            return this.readFrame(wsClient, result);
        }
        catch (SocketTimeoutException readTimeout) {
            if (this.getOptional()) {
                return null;
            }
            throw readTimeout;
        }
    }

    @Override
    protected Frame readFrame(WebSocketClient wsClient, SampleResult result) throws IOException, UnexpectedFrameException {
        boolean gotExpectedFrameType;
        Frame receivedFrame = super.readFrame(wsClient, result);
        switch (this.getDataType()) {
            case Text: {
                gotExpectedFrameType = receivedFrame instanceof TextFrame;
                break;
            }
            case Binary: {
                gotExpectedFrameType = receivedFrame instanceof BinaryFrame;
                break;
            }
            case Any: {
                gotExpectedFrameType = receivedFrame instanceof DataFrame;
                break;
            }
            default: {
                gotExpectedFrameType = false;
            }
        }
        if (gotExpectedFrameType) {
            return receivedFrame;
        }
        throw new UnexpectedFrameException(receivedFrame);
    }

    @Override
    protected void postProcessResponse(Frame response, SampleResult result) {
        if (response == null && this.getOptional()) {
            log.debug("Sampler '" + this.getName() + "' received no response (read timeout).");
            result.setSuccessful(true);
            result.setResponseCode("No response");
            result.setResponseMessage("Read timeout, no response received.");
        } else {
            boolean binaryFrame = response instanceof BinaryFrame;
            DataPayloadType frameType = binaryFrame ? DataPayloadType.Binary : DataPayloadType.Text;
            this.processDefaultReadResponse((DataFrame)response, frameType, result);
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected String validateArguments() {
        String errorMsg = null;
        if (this.getCreateNewConnection() && (errorMsg = this.validatePortNumber(this.getPort())) == null) {
            errorMsg = this.validateConnectionTimeout(this.getConnectTimeout());
        }
        if (errorMsg == null) {
            errorMsg = this.validateReadTimeout(this.getReadTimeout());
        }
        return errorMsg;
    }

    public String getServer() {
        return this.getPropertyAsString("server");
    }

    public void setServer(String server) {
        this.setProperty("server", server);
    }

    public String getPort() {
        return this.getPropertyAsString("port", "80").trim();
    }

    public void setPort(String port) {
        this.setProperty("port", port);
    }

    public String getPath() {
        return this.getPropertyAsString("path");
    }

    public void setPath(String path) {
        this.setProperty("path", path);
    }

    public boolean getBinary() {
        return this.getPropertyAsBoolean("binaryPayload");
    }

    public void setBinary(boolean binary) {
        this.setProperty("binaryPayload", binary);
    }

    public DataType getDataType() {
        String dataTypeValue = this.getPropertyAsString("dataType");
        if (dataTypeValue != null && !dataTypeValue.isEmpty()) {
            return DataType.valueOf(dataTypeValue);
        }
        if (this.getBinary()) {
            return DataType.Binary;
        }
        return DataType.Text;
    }

    public void setDataType(DataType dataType) {
        this.setProperty("dataType", dataType.name());
    }

    public String toString() {
        return "WS Read sampler '" + this.getName() + "'";
    }

    public boolean getCreateNewConnection() {
        return this.getPropertyAsBoolean("createNewConnection");
    }

    public void setCreateNewConnection(boolean value) {
        this.setProperty("createNewConnection", value);
    }

    public boolean getOptional() {
        return this.getPropertyAsBoolean("optional");
    }

    public void setOptional(boolean optional) {
        this.setProperty("optional", optional);
    }

    public static enum DataType {
        Text,
        Binary,
        Any;

    }
}

