/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.GuiUtils;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.swing.SpringUtilities;

class TestRegexDialog
extends JDialog {
    private int initialNrOfSamples = 3;
    private JTextField regex;
    private Pattern regexPattern;
    private List<JTextField> samples = new ArrayList<JTextField>();
    private List<JLabel> yesLabels = new ArrayList<JLabel>();
    private List<JLabel> noLabels = new ArrayList<JLabel>();
    private boolean returnRegex = false;
    private boolean mustMatch;

    public TestRegexDialog(Window parent, String initialRegexValue, boolean mustMatch, final Function<TestRegexDialog, Boolean> closeCallback) {
        super(parent);
        this.setTitle("Test regular expression - " + (mustMatch ? "full match" : "contains match"));
        this.mustMatch = mustMatch;
        this.setModal(true);
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 1));
        outerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, ""), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        JPanel headerPanel = new JPanel(new FlowLayout(0, 6, 9));
        JLabel usageLabel = new JLabel(mustMatch ? "<html>Samples must <em>match</em> regex.</html>" : "<html>Samples must <em>contain</em> value matching regex.</html>");
        headerPanel.add(usageLabel);
        outerPanel.add((Component)headerPanel, "North");
        headerPanel.setAlignmentX(0.0f);
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new SpringLayout());
        gridPanel.add(new JLabel("Regular expression:"));
        this.regex = new JTextField(initialRegexValue);
        gridPanel.add(this.regex);
        gridPanel.add(Box.createHorizontalStrut(1));
        gridPanel.add(Box.createHorizontalStrut(1));
        for (int i = 0; i < this.initialNrOfSamples; ++i) {
            gridPanel.add(new JLabel("Sample " + (i + 1) + ":"));
            JTextField sample = new JTextField("<add sample text here>");
            gridPanel.add(sample);
            this.samples.add(sample);
            JLabel yes = new JLabel("\u2713");
            yes.setForeground(GuiUtils.getLookAndFeelColor("Icon.okForeground"));
            gridPanel.add(yes);
            this.yesLabels.add(yes);
            JLabel no = new JLabel("\u2715");
            no.setForeground(GuiUtils.getLookAndFeelColor("Icon.errorForeground"));
            gridPanel.add(no);
            this.noLabels.add(no);
        }
        SpringUtilities.makeCompactGrid(gridPanel, 1 + this.initialNrOfSamples, 4, 6, 6, 6, 6);
        outerPanel.add(gridPanel);
        gridPanel.setAlignmentX(0.0f);
        this.add(outerPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 1, 3));
        JButton useThisButton = new JButton("Use this regex");
        useThisButton.addActionListener(e -> {
            this.returnRegex = true;
            this.dispose();
        });
        buttonPanel.add(useThisButton);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(e -> this.dispose());
        buttonPanel.add(closeButton);
        this.add((Component)buttonPanel, "South");
        this.pack();
        this.regex.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TestRegexDialog.this.compileRegex();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TestRegexDialog.this.compileRegex();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TestRegexDialog.this.compileRegex();
            }
        });
        for (JTextField sample : this.samples) {
            sample.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TestRegexDialog.this.evaluate();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TestRegexDialog.this.evaluate();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    TestRegexDialog.this.evaluate();
                }
            });
        }
        this.compileRegex();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                closeCallback.apply(TestRegexDialog.this);
            }
        });
        this.setLocationRelativeTo(this.getParent());
    }

    void compileRegex() {
        try {
            this.regexPattern = Pattern.compile(this.regex.getText());
            this.regex.setForeground(GuiUtils.getLookAndFeelColor("TextField.foreground"));
            this.evaluate();
        }
        catch (PatternSyntaxException exception) {
            this.setIndeterminate();
            this.regex.setForeground(GuiUtils.getLookAndFeelColor("TextField.errorForeground"));
        }
    }

    private void setIndeterminate() {
        for (JLabel yes : this.yesLabels) {
            yes.setVisible(false);
        }
        for (JLabel no : this.noLabels) {
            no.setVisible(false);
        }
    }

    void evaluate() {
        for (int i = 0; i < this.samples.size(); ++i) {
            Matcher matcher = this.regexPattern.matcher(this.samples.get(i).getText());
            boolean matches = this.mustMatch ? matcher.matches() : matcher.find();
            this.yesLabels.get(i).setVisible(matches);
            this.noLabels.get(i).setVisible(!matches);
        }
    }

    public boolean isReturnRegex() {
        return this.returnRegex;
    }

    public String getRegex() {
        return this.regex.getText();
    }
}

