/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.ComparisonType;
import eu.luminis.jmeter.wssampler.DynamicTitledBorder;
import eu.luminis.jmeter.wssampler.GuiUtils;
import eu.luminis.jmeter.wssampler.TestRegexDialog;
import eu.luminis.jmeter.wssampler.WebSocketSamplerGuiPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TextFrameFilterGuiPanel
extends JPanel {
    private final JButton testRegexButton;
    private JPanel matchPanel;
    JTextArea matchValue;
    private JComboBox typeSelector1;
    private JComboBox typeSelector2;
    private JComboBox typeSelector3;
    private boolean useRegex;
    private DynamicTitledBorder matchPanelPanelBorder;

    public TextFrameFilterGuiPanel() {
        this.setLayout(new BoxLayout(this, 1));
        JSplitPane splitter = new JSplitPane(0);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Frame filter condition"), BorderFactory.createEmptyBorder(1, 5, 1, 1)));
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new FlowLayout(0));
        settingsPanel.add(new JLabel("Discard any text frame"));
        this.typeSelector1 = new JComboBox<String>(new String[]{"", "that", "that does NOT"});
        settingsPanel.add(this.typeSelector1);
        this.typeSelector2 = new JComboBox();
        this.typeSelector2.setPrototypeDisplayValue("starts with");
        settingsPanel.add(this.typeSelector2);
        this.typeSelector3 = new JComboBox();
        this.typeSelector3.setPrototypeDisplayValue("regular expression");
        settingsPanel.add(this.typeSelector3);
        contentPanel.add(settingsPanel);
        settingsPanel.setAlignmentX(0.0f);
        this.matchPanel = new JPanel();
        this.matchPanelPanelBorder = new DynamicTitledBorder(null, "Text ", 1, 0);
        this.matchPanel.setBorder(BorderFactory.createCompoundBorder(this.matchPanelPanelBorder, new EmptyBorder(5, 5, 5, 5)));
        this.matchPanel.setLayout(new BorderLayout());
        this.matchValue = new JTextArea();
        this.matchValue.setLineWrap(true);
        this.matchValue.setRows(2);
        JScrollPane scrollPane = new JScrollPane(this.matchValue);
        scrollPane.setMaximumSize(new Dimension(scrollPane.getMaximumSize().width, Integer.MAX_VALUE));
        scrollPane.setBorder(new JTextField().getBorder());
        scrollPane.setAlignmentY(0.5f);
        this.matchValue.setEnabled(false);
        this.matchPanelPanelBorder.setEnabled(false);
        this.matchPanel.add(scrollPane);
        contentPanel.add(this.matchPanel);
        this.matchPanel.setAlignmentX(0.0f);
        JPanel matchPositionPanel = new JPanel(new FlowLayout(0, -4, 0));
        this.testRegexButton = new JButton("Test regular expression");
        this.testRegexButton.setEnabled(false);
        this.testRegexButton.addActionListener(e -> new TestRegexDialog(SwingUtilities.getWindowAncestor(this), this.matchValue.getText(), this.typeSelector2.getSelectedIndex() == 2, dlg -> {
            if (dlg.isReturnRegex()) {
                this.matchValue.setText(dlg.getRegex());
            }
            return dlg.isReturnRegex();
        }).setVisible(true));
        matchPositionPanel.add(this.testRegexButton);
        matchPositionPanel.setAlignmentX(0.0f);
        contentPanel.add(matchPositionPanel);
        splitter.setBorder(null);
        splitter.setTopComponent(contentPanel);
        splitter.setBottomComponent(WebSocketSamplerGuiPanel.createAboutPanel(this));
        splitter.setAlignmentX(0.0f);
        this.add(splitter);
        this.typeSelector1.addActionListener(e -> {
            int selectedItem = this.typeSelector2.getSelectedIndex();
            this.typeSelector2.removeAllItems();
            switch (this.typeSelector1.getSelectedIndex()) {
                case 0: {
                    this.typeSelector3.removeAllItems();
                    this.matchValue.setEnabled(false);
                    this.matchPanelPanelBorder.setEnabled(false);
                    this.matchPanel.repaint();
                    break;
                }
                case 1: {
                    this.typeSelector2.addItem("contains");
                    this.typeSelector2.addItem("starts with");
                    this.typeSelector2.addItem("equals");
                    this.typeSelector2.addItem("ends with");
                    if (selectedItem >= 0) {
                        this.typeSelector2.setSelectedIndex(selectedItem);
                    }
                    this.matchValue.setEnabled(true);
                    this.matchPanelPanelBorder.setEnabled(true);
                    this.matchPanel.repaint();
                    break;
                }
                case 2: {
                    this.typeSelector2.addItem("contain");
                    this.typeSelector2.addItem("start with");
                    this.typeSelector2.addItem("equal");
                    this.typeSelector2.addItem("end with");
                    if (selectedItem >= 0) {
                        this.typeSelector2.setSelectedIndex(selectedItem);
                    }
                    this.matchValue.setEnabled(true);
                    this.matchPanelPanelBorder.setEnabled(true);
                    this.matchPanel.repaint();
                }
            }
        });
        this.typeSelector2.addActionListener(e -> {
            int previousSelection = this.typeSelector3.getSelectedIndex();
            this.typeSelector3.removeAllItems();
            if (this.typeSelector2.getSelectedIndex() == 1 || this.typeSelector2.getSelectedIndex() == 3) {
                this.typeSelector3.addItem("text");
            } else {
                this.typeSelector3.addItem("text");
                this.typeSelector3.addItem("regular expression");
                if (previousSelection != -1) {
                    this.typeSelector3.setSelectedIndex(previousSelection);
                }
            }
        });
        this.typeSelector3.addActionListener(e -> {
            this.useRegex = this.typeSelector3.getSelectedIndex() == 1;
            this.matchPanelPanelBorder.setTitle(this.useRegex ? "Regular expression" : "Text");
            this.testRegexButton.setEnabled(this.useRegex);
            this.matchPanel.repaint();
            if (this.useRegex) {
                this.compileRegex();
            } else {
                this.resetRegexValidation();
            }
        });
        this.matchValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (TextFrameFilterGuiPanel.this.useRegex) {
                    TextFrameFilterGuiPanel.this.compileRegex();
                } else {
                    TextFrameFilterGuiPanel.this.resetRegexValidation();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (TextFrameFilterGuiPanel.this.useRegex) {
                    TextFrameFilterGuiPanel.this.compileRegex();
                } else {
                    TextFrameFilterGuiPanel.this.resetRegexValidation();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (TextFrameFilterGuiPanel.this.useRegex) {
                    TextFrameFilterGuiPanel.this.compileRegex();
                } else {
                    TextFrameFilterGuiPanel.this.resetRegexValidation();
                }
            }
        });
    }

    void compileRegex() {
        try {
            Pattern.compile(this.matchValue.getText());
            this.matchValue.setForeground(GuiUtils.getLookAndFeelColor("TextArea.foreground"));
        }
        catch (PatternSyntaxException exception) {
            this.matchValue.setForeground(GuiUtils.getLookAndFeelColor("TextField.errorForeground"));
        }
    }

    void resetRegexValidation() {
        this.matchValue.setForeground(GuiUtils.getLookAndFeelColor("TextArea.foreground"));
    }

    ComparisonType getComparisonType() {
        int code = 100 * this.typeSelector1.getSelectedIndex() + 10 * this.typeSelector2.getSelectedIndex() + this.typeSelector3.getSelectedIndex();
        switch (code) {
            case -111: 
            case -11: 
            case -1: 
            case 0: {
                return ComparisonType.IsPlain;
            }
            case 100: {
                return ComparisonType.Contains;
            }
            case 101: {
                return ComparisonType.ContainsRegex;
            }
            case 110: {
                return ComparisonType.StartsWith;
            }
            case 120: {
                return ComparisonType.Equals;
            }
            case 121: {
                return ComparisonType.EqualsRegex;
            }
            case 130: {
                return ComparisonType.EndsWith;
            }
            case 200: {
                return ComparisonType.NotContains;
            }
            case 201: {
                return ComparisonType.NotContainsRegex;
            }
            case 210: {
                return ComparisonType.NotStartsWith;
            }
            case 220: {
                return ComparisonType.NotEquals;
            }
            case 221: {
                return ComparisonType.NotEqualsRegex;
            }
            case 230: {
                return ComparisonType.NotEndsWith;
            }
        }
        throw new RuntimeException("invalid comparison type (" + code + ")");
    }

    void setComparisonType(ComparisonType type) {
        switch (type) {
            case IsPlain: {
                this.typeSelector1.setSelectedIndex(0);
                break;
            }
            case Contains: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(0);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            case ContainsRegex: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(0);
                this.typeSelector3.setSelectedIndex(1);
                break;
            }
            case StartsWith: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(1);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            case Equals: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(2);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            case EqualsRegex: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(2);
                this.typeSelector3.setSelectedIndex(1);
                break;
            }
            case EndsWith: {
                this.typeSelector1.setSelectedIndex(1);
                this.typeSelector2.setSelectedIndex(3);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            case NotContains: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(0);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            case NotContainsRegex: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(0);
                this.typeSelector3.setSelectedIndex(1);
                break;
            }
            case NotStartsWith: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(1);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            case NotEquals: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(2);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            case NotEqualsRegex: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(2);
                this.typeSelector3.setSelectedIndex(1);
                break;
            }
            case NotEndsWith: {
                this.typeSelector1.setSelectedIndex(2);
                this.typeSelector2.setSelectedIndex(3);
                this.typeSelector3.setSelectedIndex(0);
                break;
            }
            default: {
                throw new RuntimeException("invalid comparison type");
            }
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(700, 400);
        frame.setLocation(new Point(400, 400));
        frame.getContentPane().add(new TextFrameFilterGuiPanel());
        frame.setVisible(true);
    }
}

