/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.jmeter.wssampler;

import eu.luminis.jmeter.wssampler.DataPayloadType;
import eu.luminis.jmeter.wssampler.WebsocketSampler;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;

public abstract class WebsocketGeneralSampler
extends WebsocketSampler {
    private static final String PROPERTY_PAYLOAD = "payloadType";
    private static final String PROPERTY_PAYLOAD_LEGACY_IS_BINARY = "binaryPayload";
    private static final DataPayloadType PROPERTY_PAYLOAD_DEFAULT = DataPayloadType.Text;

    public DataPayloadType getType() {
        JMeterProperty value = this.getProperty(PROPERTY_PAYLOAD);
        if (value == null || value instanceof NullProperty) {
            JMeterProperty legacyValue = this.getProperty(PROPERTY_PAYLOAD_LEGACY_IS_BINARY);
            if (legacyValue == null || legacyValue instanceof NullProperty) {
                return PROPERTY_PAYLOAD_DEFAULT;
            }
            boolean binaryPayload = legacyValue.getBooleanValue();
            return binaryPayload ? DataPayloadType.Binary : DataPayloadType.Text;
        }
        try {
            return DataPayloadType.valueOf(value.getStringValue());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warn("Wrong value found for payloadType: '" + value + "'");
            return PROPERTY_PAYLOAD_DEFAULT;
        }
    }

    public void setType(DataPayloadType type) {
        this.setProperty(PROPERTY_PAYLOAD, type.name());
    }
}

