/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import eu.luminis.jmeter.wssampler.BinaryUtils;
import eu.luminis.websocket.DataFrame;

public class BinaryFrame
extends DataFrame {
    private byte[] data;
    int nrBytesPrintedInToString = 16;

    public BinaryFrame(byte[] payload) {
        this.data = payload;
    }

    public BinaryFrame(boolean fin, byte[] payload, int size) {
        super(fin, size);
        this.data = payload;
    }

    public byte[] getBinaryData() {
        return this.data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public String toString() {
        if (this.data.length > 0) {
            return "Binary frame, payload (length " + this.data.length + "): " + BinaryUtils.formatBinary(this.data, this.nrBytesPrintedInToString, " ...");
        }
        return "Binary frame, empty payload";
    }

    @Override
    protected byte[] getPayload() {
        return this.data;
    }

    @Override
    protected byte getOpCode() {
        return 2;
    }

    @Override
    public String getTypeAsString() {
        if (this.isFinalFragment()) {
            return "binary";
        }
        return "non-final binary";
    }

    @Override
    public int getPayloadSize() {
        return this.data.length;
    }
}

