/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import java.io.IOException;
import java.io.OutputStream;

public class CountingOutputStream
extends OutputStream {
    private OutputStream wrappedStream;
    private int count = 0;

    public CountingOutputStream(OutputStream out) {
        this.wrappedStream = out;
    }

    public int getCount() {
        return this.count;
    }

    public void resetCount() {
        this.count = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this.wrappedStream.write(b);
        ++this.count;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.wrappedStream.write(b);
        this.count += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.wrappedStream.write(b, off, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.wrappedStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }
}

