/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import eu.luminis.websocket.BinaryContinuationFrame;
import eu.luminis.websocket.BinaryFrame;
import eu.luminis.websocket.CloseFrame;
import eu.luminis.websocket.EndOfStreamException;
import eu.luminis.websocket.PingFrame;
import eu.luminis.websocket.PongFrame;
import eu.luminis.websocket.TextContinuationFrame;
import eu.luminis.websocket.TextFrame;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.Random;
import org.apache.log.Logger;

public abstract class Frame {
    public static final int OPCODE_CONT = 0;
    public static final int OPCODE_TEXT = 1;
    public static final int OPCODE_BINARY = 2;
    public static final int OPCODE_CLOSE = 8;
    public static final int OPCODE_PING = 9;
    public static final int OPCODE_PONG = 10;
    public static final int FIN_BIT_ON = 128;
    public static final int MASK_BIT_MASKED = 128;
    private static Random randomGenerator = new Random();
    private int frameSize;

    static Frame parseFrame(DataFrameType previousDataFrameType, InputStream istream) throws IOException {
        return Frame.parseFrame(previousDataFrameType, istream, null);
    }

    static Frame parseFrame(DataFrameType previousDataFrameType, InputStream istream, Logger log) throws IOException {
        boolean markSupported = istream.markSupported();
        if (!markSupported) {
            throw new IllegalStateException("readFromStream should be called with an InputStream that supports mark/reset");
        }
        try {
            int bytesRead;
            int length;
            istream.mark(10);
            int byte1 = istream.read();
            if (byte1 == -1) {
                throw new EndOfStreamException("end of stream");
            }
            int byte2 = istream.read();
            if (byte2 == -1) {
                throw new EndOfStreamException("end of stream");
            }
            boolean fin = (byte1 & 0x80) != 0;
            int opCode = byte1 & 0xF;
            int firstLengthByte = byte2 & 0x7F;
            int nrOfLenghtBytes = 0;
            if (firstLengthByte < 126) {
                length = firstLengthByte;
                Frame.updateMarkLimit(2 + length, istream, 2);
            } else if (firstLengthByte == 126) {
                byte1 = istream.read();
                if (byte1 == -1) {
                    throw new EndOfStreamException("end of stream");
                }
                byte2 = istream.read();
                if (byte2 == -1) {
                    throw new EndOfStreamException("end of stream");
                }
                length = (byte1 & 0xFF) << 8 | byte2 & 0xFF;
                Frame.updateMarkLimit(4 + length, istream, 4);
                nrOfLenghtBytes = 2;
            } else {
                byte[] lengthBytes = new byte[8];
                bytesRead = Frame.readFromStream(istream, lengthBytes, log);
                if (bytesRead != lengthBytes.length) {
                    throw new EndOfStreamException("WebSocket protocol error: expected " + lengthBytes.length + " length bytes, but can only read " + bytesRead + " bytes");
                }
                if (lengthBytes[0] != 0 || lengthBytes[1] != 0 || lengthBytes[2] != 0 || lengthBytes[3] != 0) {
                    throw new RuntimeException("Frame too large; Java does not support arrays longer than 2147483647 bytes.");
                }
                if ((lengthBytes[4] & 0x80) == 128) {
                    throw new RuntimeException("Frame too large; Java does not support arrays longer than 2147483647 bytes.");
                }
                length = (lengthBytes[4] & 0xFF) << 24 | (lengthBytes[5] & 0xFF) << 16 | (lengthBytes[6] & 0xFF) << 8 | (lengthBytes[7] & 0xFF) << 0;
                nrOfLenghtBytes = 8;
                Frame.updateMarkLimit(10 + length, istream, 10);
            }
            byte[] payload = new byte[length];
            bytesRead = Frame.readFromStream(istream, payload, log);
            if (bytesRead == -1) {
                throw new EndOfStreamException("end of stream");
            }
            if (bytesRead != length) {
                throw new EndOfStreamException("WebSocket protocol error: expected payload of length " + length + ", but can only read " + bytesRead + " bytes");
            }
            switch (opCode) {
                case 0: {
                    if (previousDataFrameType == DataFrameType.TEXT) {
                        return new TextContinuationFrame(fin, payload, 2 + nrOfLenghtBytes + length);
                    }
                    if (previousDataFrameType == DataFrameType.BIN) {
                        return new BinaryContinuationFrame(fin, payload, 2 + nrOfLenghtBytes + length);
                    }
                    throw new ProtocolException("no continuation frame expected");
                }
                case 1: {
                    return new TextFrame(fin, payload, 2 + nrOfLenghtBytes + length);
                }
                case 2: {
                    return new BinaryFrame(fin, payload, 2 + nrOfLenghtBytes + length);
                }
                case 8: {
                    return new CloseFrame(payload, 2 + nrOfLenghtBytes + length);
                }
                case 9: {
                    return new PingFrame(payload, 2 + nrOfLenghtBytes + length);
                }
                case 10: {
                    return new PongFrame(payload, 2 + nrOfLenghtBytes + length);
                }
            }
            throw new RuntimeException("unsupported frame type: " + opCode);
        }
        catch (SocketTimeoutException timeout) {
            istream.reset();
            throw timeout;
        }
    }

    private static void updateMarkLimit(int readLimit, InputStream stream, int bytesRead) throws IOException {
        stream.reset();
        stream.mark(readLimit);
        stream.read(new byte[bytesRead]);
    }

    protected Frame(int size) {
        this.frameSize = size;
    }

    public byte[] getFrameBytes() {
        byte[] mask = new byte[4];
        randomGenerator.nextBytes(mask);
        byte[] payload = this.getPayload();
        byte[] lengthBytes = payload.length <= 125 ? new byte[]{(byte)payload.length} : (payload.length < 65536 ? new byte[]{126, (byte)(payload.length >> 8), (byte)(payload.length >> 0)} : new byte[]{127, 0, 0, 0, 0, (byte)(payload.length >> 24), (byte)(payload.length >> 16), (byte)(payload.length >> 8), (byte)(payload.length >> 0)});
        byte[] masked = new byte[payload.length];
        for (int i = 0; i < payload.length; ++i) {
            masked[i] = (byte)(payload[i] ^ mask[i % 4]);
        }
        byte[] frame = new byte[1 + lengthBytes.length + 4 + payload.length];
        frame[0] = (byte)(0x80 | this.getOpCode());
        frame[1] = (byte)(0x80 | lengthBytes[0]);
        System.arraycopy(lengthBytes, 1, frame, 2, lengthBytes.length - 1);
        System.arraycopy(mask, 0, frame, 1 + lengthBytes.length, 4);
        System.arraycopy(masked, 0, frame, 1 + lengthBytes.length + 4, payload.length);
        this.frameSize = frame.length;
        return frame;
    }

    protected static int readFromStream(InputStream stream, byte[] buffer) throws IOException {
        return Frame.readFromStream(stream, buffer, null);
    }

    protected static int readFromStream(InputStream stream, byte[] buffer, Logger log) throws IOException {
        return Frame.readFromStream(stream, buffer, 0, buffer.length, log);
    }

    protected static int readFromStream(InputStream stream, byte[] buffer, int offset, int expected, Logger logger) throws IOException {
        if (expected == 0 || buffer.length == 0) {
            return 0;
        }
        if (offset + expected > buffer.length) {
            logger.error("readFromStream() called with wrong offset/expected; limiting number of bytes read");
            expected = buffer.length - offset;
        }
        int toRead = expected;
        int totalRead = 0;
        try {
            do {
                int bytesRead;
                if ((bytesRead = stream.read(buffer, offset, toRead)) < 0) {
                    return totalRead;
                }
                if (bytesRead == 0) {
                    logger.error("Blocking read fails with 0 bytes read.");
                    int singleByte = stream.read();
                    if (singleByte == -1) {
                        return totalRead;
                    }
                    buffer[offset] = (byte)singleByte;
                    ++offset;
                    toRead = expected - ++totalRead;
                    continue;
                }
                offset += bytesRead;
                toRead = expected - (totalRead += bytesRead);
            } while (totalRead < expected);
        }
        catch (SocketTimeoutException timeout) {
            if (totalRead > 0) {
                logger.debug("Read was interrupted by socket timeout; " + totalRead + " bytes read.");
            }
            throw timeout;
        }
        return totalRead;
    }

    public boolean isData() {
        return this.isText() || this.isBinary();
    }

    public boolean isText() {
        return false;
    }

    public boolean isBinary() {
        return false;
    }

    public boolean isControl() {
        return !this.isText() && !this.isBinary();
    }

    public boolean isClose() {
        return false;
    }

    public boolean isPing() {
        return false;
    }

    public boolean isPong() {
        return false;
    }

    protected abstract byte[] getPayload();

    protected abstract byte getOpCode();

    public abstract String getTypeAsString();

    public int getSize() {
        if (this.frameSize == 0) {
            this.frameSize = this.getFrameBytes().length;
        }
        return this.frameSize;
    }

    public abstract int getPayloadSize();

    static enum DataFrameType {
        NONE,
        TEXT,
        BIN;

    }
}

