/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import eu.luminis.websocket.ControlFrame;

public class PingFrame
extends ControlFrame {
    private byte[] applicationData;

    public PingFrame(byte[] payload) {
        super(0);
        this.applicationData = payload;
    }

    public PingFrame(byte[] payload, int size) {
        super(size);
        this.applicationData = payload;
    }

    public byte[] getData() {
        return this.applicationData;
    }

    public String toString() {
        return "Ping frame with " + (String)(this.applicationData.length > 0 ? "application data '" + new String(this.applicationData) + "'" : "no application data");
    }

    @Override
    public boolean isPing() {
        return true;
    }

    @Override
    protected byte[] getPayload() {
        return this.applicationData;
    }

    @Override
    protected byte getOpCode() {
        return 9;
    }

    @Override
    public String getTypeAsString() {
        return "ping";
    }

    @Override
    public int getPayloadSize() {
        return this.applicationData.length;
    }
}

