/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import eu.luminis.websocket.ControlFrame;

public class PongFrame
extends ControlFrame {
    private byte[] applicationData;

    public PongFrame(byte[] payload) {
        super(0);
        this.applicationData = payload;
    }

    public PongFrame(byte[] payload, int size) {
        super(size);
        this.applicationData = payload;
    }

    public byte[] getData() {
        return this.applicationData;
    }

    @Override
    public boolean isPong() {
        return true;
    }

    public String toString() {
        return "Pong frame with " + (String)(this.applicationData.length > 0 ? "application data '" + new String(this.applicationData) + "'" : "no application data");
    }

    @Override
    protected byte[] getPayload() {
        return this.applicationData;
    }

    @Override
    protected byte getOpCode() {
        return 10;
    }

    @Override
    public String getTypeAsString() {
        return "pong";
    }

    @Override
    public int getPayloadSize() {
        return this.applicationData.length;
    }
}

