/*
 * Decompiled with CFR 0.152.
 */
package eu.luminis.websocket;

import eu.luminis.websocket.BinaryFrame;
import eu.luminis.websocket.CloseFrame;
import eu.luminis.websocket.CountingInputStream;
import eu.luminis.websocket.CountingOutputStream;
import eu.luminis.websocket.DataFrame;
import eu.luminis.websocket.Frame;
import eu.luminis.websocket.HttpException;
import eu.luminis.websocket.HttpLineReader;
import eu.luminis.websocket.HttpProtocolException;
import eu.luminis.websocket.HttpUpgradeException;
import eu.luminis.websocket.PingFrame;
import eu.luminis.websocket.PongFrame;
import eu.luminis.websocket.TextFrame;
import eu.luminis.websocket.UnexpectedFrameException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WebSocketClient {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String NEW_LINE = "\r\n";
    private static final Pattern HTTP_STATUS_PATTERN = Pattern.compile("^HTTP/\\d\\.\\d (\\d{3}?)");
    public static final int DEFAULT_CONNECT_TIMEOUT = 20000;
    public static final int DEFAULT_READ_TIMEOUT = 6000;
    public static Set<String> UPGRADE_HEADERS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Frame.DataFrameType lastDataFrameStatus = Frame.DataFrameType.NONE;
    private final URL connectUrl;
    private Socket wsSocket;
    private InputStream socketInputStream;
    private OutputStream socketOutputStream;
    private Random randomGenerator = new Random();
    private volatile WebSocketState state = WebSocketState.CLOSED;
    private Map<String, String> additionalHeaders;
    private boolean useProxy;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public WebSocketClient(URL wsURL) {
        this.connectUrl = this.correctUrl(wsURL);
    }

    public URL getConnectUrl() {
        return this.connectUrl;
    }

    public void setAdditionalUpgradeRequestHeaders(Map<String, String> additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void useProxy(String host, int port, String user, String password) {
        this.useProxy = true;
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUsername = user;
        this.proxyPassword = password;
    }

    public HttpResult connect() throws IOException, HttpException {
        return this.connect(Collections.emptyMap(), 20000, 6000);
    }

    public HttpResult connect(int connectTimeout, int readTimeout) throws IOException, HttpException {
        return this.connect(Collections.emptyMap(), connectTimeout, readTimeout);
    }

    public HttpResult connect(Map<String, String> headers) throws IOException, HttpException {
        if (this.additionalHeaders != null && !this.additionalHeaders.isEmpty() && headers != null && !headers.isEmpty()) {
            throw new IllegalArgumentException("Cannot pass headers when setAdditionalUpgradeRequestHeaders is called before");
        }
        return this.connect(headers, 20000, 6000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResult connect(Map<String, String> headers, int connectTimeout, int readTimeout) throws IOException, HttpException {
        HttpResult httpResult;
        block13: {
            if (headers != null && !headers.isEmpty()) {
                if (this.additionalHeaders != null && !this.additionalHeaders.isEmpty()) {
                    throw new IllegalArgumentException("Cannot pass headers when setAdditionalUpgradeRequestHeaders is called before");
                }
            } else {
                headers = this.additionalHeaders;
            }
            if (headers == null) {
                headers = Collections.emptyMap();
            }
            if (this.state != WebSocketState.CLOSED) {
                throw new IllegalStateException("Cannot connect when state is " + this.state);
            }
            this.state = WebSocketState.CONNECTING;
            boolean connected = false;
            log.debug("Creating connection with " + this.connectUrl.getHost() + ":" + this.connectUrl.getPort());
            if (System.getProperty("socksProxyHost", null) != null) {
                log.warn("Socks proxy host is set, but socks proxy is not officially supported.");
            }
            this.wsSocket = this.createSocket(this.connectUrl.getHost(), this.connectUrl.getPort(), connectTimeout, readTimeout);
            Map<String, String> responseHeaders = null;
            CountingOutputStream outStream = null;
            CountingInputStream inStream = null;
            PrintWriter httpWriter = null;
            try {
                this.wsSocket.setSoTimeout(readTimeout);
                this.socketOutputStream = this.wsSocket.getOutputStream();
                Object path = this.connectUrl.getFile();
                if (path == null || !((String)path).trim().startsWith("/")) {
                    path = "/" + (String)path;
                }
                outStream = new CountingOutputStream(this.socketOutputStream);
                httpWriter = new PrintWriter(outStream);
                httpWriter.print("GET " + (String)(this.useProxy ? this.connectUrl.toString() : path) + " HTTP/1.1\r\n");
                log.debug(">> GET " + (String)(this.useProxy ? this.connectUrl.toString() : path) + " HTTP/1.1");
                httpWriter.print("Host: " + this.connectUrl.getHost() + ":" + this.connectUrl.getPort() + NEW_LINE);
                log.debug(">> Host: " + this.connectUrl.getHost() + ":" + this.connectUrl.getPort());
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    if (!UPGRADE_HEADERS.contains(header.getKey())) {
                        String headerLine = header.getKey() + ": " + header.getValue();
                        if (!headerLine.contains("\r") && !headerLine.contains("\n")) {
                            httpWriter.print(headerLine + NEW_LINE);
                            log.debug(">> " + headerLine);
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid header; contains new line.");
                    }
                    log.error("Ignoring user supplied header '" + header + "'");
                }
                httpWriter.print("Upgrade: websocket\r\n");
                log.debug(">> Upgrade: websocket");
                httpWriter.print("Connection: Upgrade\r\n");
                log.debug(">> Connection: Upgrade");
                byte[] nonce = new byte[16];
                this.randomGenerator.nextBytes(nonce);
                String encodeNonce = new String(Base64.getEncoder().encode(nonce));
                httpWriter.print("Sec-WebSocket-Key: " + encodeNonce + NEW_LINE);
                log.debug(">> Sec-WebSocket-Key: " + encodeNonce);
                httpWriter.print("Sec-WebSocket-Version: 13\r\n");
                log.debug(">> Sec-WebSocket-Version: 13");
                httpWriter.print(NEW_LINE);
                log.debug(">>");
                httpWriter.flush();
                this.socketInputStream = new BufferedInputStream(this.wsSocket.getInputStream());
                inStream = new CountingInputStream(this.socketInputStream);
                responseHeaders = this.checkServerResponse(inStream, encodeNonce);
                connected = true;
                this.state = WebSocketState.CONNECTED;
                httpResult = new HttpResult(responseHeaders, outStream.getCount(), inStream.getCount());
                if (connected) break block13;
            }
            catch (Throwable throwable) {
                if (!connected) {
                    IOUtils.closeQuietly((InputStream)this.socketInputStream);
                    IOUtils.closeQuietly((OutputStream)this.socketOutputStream);
                    IOUtils.closeQuietly((Socket)this.wsSocket);
                    IOUtils.closeQuietly(httpWriter);
                    this.state = WebSocketState.CLOSED;
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)this.socketInputStream);
            IOUtils.closeQuietly((OutputStream)this.socketOutputStream);
            IOUtils.closeQuietly((Socket)this.wsSocket);
            IOUtils.closeQuietly((Writer)httpWriter);
            this.state = WebSocketState.CLOSED;
        }
        return httpResult;
    }

    public boolean isConnected() {
        return this.state == WebSocketState.CONNECTED;
    }

    protected Socket createSocket(String host, int port, int connectTimeout, int readTimeout) throws IOException {
        Socket baseSocket = new Socket();
        if (this.useProxy) {
            log.debug("Using http proxy " + this.proxyHost + ":" + this.proxyPort + " for " + this.connectUrl);
            this.setupProxyConnection(baseSocket, connectTimeout);
        } else {
            baseSocket.connect(new InetSocketAddress(host, port), connectTimeout);
        }
        if ("https".equals(this.connectUrl.getProtocol())) {
            baseSocket.setSoTimeout(readTimeout);
            JsseSSLManager sslMgr = (JsseSSLManager)SSLManager.getInstance();
            try {
                SSLSocketFactory tlsSocketFactory = sslMgr.getContext().getSocketFactory();
                log.debug("Starting TLS connection.");
                return tlsSocketFactory.createSocket(baseSocket, host, port, true);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e);
            }
        }
        return baseSocket;
    }

    private void setupProxyConnection(Socket socket, int connectTimeout) throws IOException {
        try {
            String line;
            socket.connect(new InetSocketAddress(this.proxyHost, this.proxyPort), connectTimeout);
            PrintWriter proxyWriter = new PrintWriter(socket.getOutputStream());
            proxyWriter.print("CONNECT " + this.connectUrl.getHost() + ":" + this.connectUrl.getPort() + " HTTP/1.1\r\n");
            log.debug(">proxy> CONNECT " + this.connectUrl.getHost() + ":" + this.connectUrl.getPort() + " HTTP/1.1");
            proxyWriter.print("Host: " + this.connectUrl.getHost() + NEW_LINE);
            log.debug(">proxy> Host: " + this.connectUrl.getHost());
            if (this.proxyUsername != null && this.proxyPassword != null) {
                String authentication = this.proxyUsername + ":" + this.proxyPassword;
                proxyWriter.print("Proxy-Authorization: Basic " + Base64.getEncoder().encodeToString(authentication.getBytes()) + NEW_LINE);
                log.debug(">proxy> Proxy-Authorization: Basic " + Base64.getEncoder().encodeToString(authentication.getBytes()));
            }
            proxyWriter.print(NEW_LINE);
            proxyWriter.flush();
            HttpLineReader httpReader = new HttpLineReader(socket.getInputStream());
            String statusLine = httpReader.readLine();
            do {
                line = httpReader.readLine();
                log.debug("<proxy< " + line);
            } while (line != null && line.trim().length() > 0);
            this.checkHttpStatus(statusLine, 200);
        }
        catch (HttpUpgradeException httpError) {
            log.error("Proxy connection error", (Throwable)httpError);
            throw new HttpUpgradeException("Connecting proxy failed with status code " + httpError.getStatusCodeAsString(), httpError.getStatusCode());
        }
        catch (SocketTimeoutException timeout) {
            log.error("Proxy connection timeout");
            throw timeout;
        }
        catch (ConnectException cantConnect) {
            log.error("Proxy connection setup error: ", (Throwable)cantConnect);
            throw new ConnectException("Proxy connection setup error: " + cantConnect.getMessage());
        }
        catch (IOException ioError) {
            log.error("Proxy connection setup error: ", (Throwable)ioError);
            throw ioError;
        }
    }

    public void dispose() {
        IOUtils.closeQuietly((InputStream)this.socketInputStream);
        IOUtils.closeQuietly((OutputStream)this.socketOutputStream);
        IOUtils.closeQuietly((Socket)this.wsSocket);
        this.state = WebSocketState.CLOSED;
    }

    public void finalize() {
        log.debug("WebSocket client is being garbage collected; underlying TCP connection will be closed");
        try {
            this.dispose();
        }
        catch (Exception error) {
            log.error("Exception thrown during finalize", (Throwable)error);
        }
    }

    public CloseFrame close(int status, String requestData, int readTimeout) throws IOException, UnexpectedFrameException {
        if (this.state != WebSocketState.CONNECTED) {
            throw new IllegalStateException("Cannot close when state is " + this.state);
        }
        this.sendClose(status, requestData);
        return this.receiveClose(readTimeout);
    }

    public TextFrame sendTextFrame(String requestData) throws IOException {
        if (this.state != WebSocketState.CONNECTED) {
            throw new IllegalStateException("Cannot send data frame when state is " + this.state);
        }
        TextFrame frame = new TextFrame(requestData);
        this.socketOutputStream.write(frame.getFrameBytes());
        return frame;
    }

    public BinaryFrame sendBinaryFrame(byte[] requestData) throws IOException {
        if (this.state != WebSocketState.CONNECTED) {
            throw new IllegalStateException("Cannot send data frame when state is " + this.state);
        }
        BinaryFrame frame = new BinaryFrame(requestData);
        this.socketOutputStream.write(frame.getFrameBytes());
        return frame;
    }

    public Frame sendPingFrame() throws IOException {
        return this.sendPingFrame(new byte[0]);
    }

    public Frame sendPingFrame(byte[] applicationData) throws IOException {
        if (this.state != WebSocketState.CONNECTED) {
            throw new IllegalStateException("Cannot send ping frame when state is " + this.state);
        }
        PingFrame ping = new PingFrame(applicationData);
        this.socketOutputStream.write(ping.getFrameBytes());
        return ping;
    }

    public Frame sendPongFrame() throws IOException {
        return this.sendPongFrame(new byte[0]);
    }

    public Frame sendPongFrame(byte[] applicationData) throws IOException {
        if (this.state != WebSocketState.CONNECTED) {
            throw new IllegalStateException("Cannot send pong frame when state is " + this.state);
        }
        PongFrame pongFrame = new PongFrame(applicationData);
        this.socketOutputStream.write(pongFrame.getFrameBytes());
        return pongFrame;
    }

    public Frame sendClose(int closeStatus, String reason) throws IOException {
        if (this.state != WebSocketState.CONNECTED && this.state != WebSocketState.CLOSED_SERVER) {
            throw new IllegalStateException("Cannot close when state is " + this.state);
        }
        CloseFrame closeFrame = new CloseFrame(closeStatus, reason);
        this.socketOutputStream.write(closeFrame.getFrameBytes());
        if (this.state == WebSocketState.CONNECTED) {
            this.state = WebSocketState.CLOSED_CLIENT;
        } else {
            this.state = WebSocketState.CLOSED;
            this.dispose();
        }
        return closeFrame;
    }

    public CloseFrame receiveClose(int timeout) throws IOException, UnexpectedFrameException {
        Frame frame = this.receiveFrame(timeout);
        if (frame.isClose()) {
            if (this.state == WebSocketState.CONNECTED) {
                this.state = WebSocketState.CLOSED_SERVER;
            } else {
                this.state = WebSocketState.CLOSED;
                this.dispose();
            }
            return (CloseFrame)frame;
        }
        throw new UnexpectedFrameException(frame);
    }

    public Frame receiveFrame(int readTimeout) throws IOException {
        if (this.state != WebSocketState.CONNECTED && this.state != WebSocketState.CLOSED_CLIENT) {
            throw new IllegalStateException("Cannot receive data frame when state is " + this.state);
        }
        this.wsSocket.setSoTimeout(readTimeout);
        Frame receivedFrame = Frame.parseFrame(this.lastDataFrameStatus, this.socketInputStream, log);
        if (this.lastDataFrameStatus == Frame.DataFrameType.NONE && receivedFrame.isData() && !((DataFrame)receivedFrame).isFinalFragment()) {
            this.lastDataFrameStatus = receivedFrame.isText() ? Frame.DataFrameType.TEXT : Frame.DataFrameType.BIN;
        } else if (this.lastDataFrameStatus != Frame.DataFrameType.NONE && receivedFrame.isData()) {
            if (((DataFrame)receivedFrame).isContinuationFrame() && ((DataFrame)receivedFrame).isFinalFragment()) {
                this.lastDataFrameStatus = Frame.DataFrameType.NONE;
            } else if (!((DataFrame)receivedFrame).isContinuationFrame()) {
                throw new ProtocolException("missing continuation frame");
            }
        }
        if (receivedFrame.isClose()) {
            if (this.state == WebSocketState.CONNECTED) {
                this.state = WebSocketState.CLOSED_SERVER;
            } else {
                this.state = WebSocketState.CLOSED;
                this.dispose();
            }
        }
        return receivedFrame;
    }

    public TextFrame receiveText(int timeout) throws IOException, UnexpectedFrameException {
        Frame frame = this.receiveFrame(timeout);
        if (frame.isText()) {
            return (TextFrame)frame;
        }
        throw new UnexpectedFrameException(frame);
    }

    public BinaryFrame receiveBinaryData(int timeout) throws IOException, UnexpectedFrameException {
        Frame frame = this.receiveFrame(timeout);
        if (frame.isBinary()) {
            return (BinaryFrame)frame;
        }
        throw new UnexpectedFrameException(frame);
    }

    public PongFrame receivePong(int timeout) throws IOException, UnexpectedFrameException {
        Frame frame = this.receiveFrame(timeout);
        if (frame.isPong()) {
            return (PongFrame)frame;
        }
        throw new UnexpectedFrameException(frame);
    }

    protected Map<String, String> checkServerResponse(InputStream inputStream, String nonce) throws IOException {
        HttpLineReader httpReader = new HttpLineReader(inputStream);
        String line = httpReader.readLine();
        if (line == null) {
            throw new HttpProtocolException("Empty response; connection closed.");
        }
        log.debug("<< " + line);
        this.checkHttpStatus(line, 101);
        TreeMap<String, String> serverHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        do {
            String[] values;
            line = httpReader.readLine();
            log.debug("<< " + line);
            if (line == null || (values = line.split(":", 2)).length <= 1) continue;
            String key = values[0];
            String value = values[1].trim();
            if (serverHeaders.containsKey(key)) {
                serverHeaders.put(key, (String)serverHeaders.get(key) + ", " + value);
                continue;
            }
            serverHeaders.put(key, value);
        } while (line != null && line.trim().length() > 0);
        if (!"websocket".equals(this.getLowerCase((String)serverHeaders.get("Upgrade")))) {
            throw new HttpUpgradeException("Server response should contain 'Upgrade' header with value 'websocket'");
        }
        if (!"upgrade".equals(this.getLowerCase((String)serverHeaders.get("Connection")))) {
            throw new HttpUpgradeException("Server response should contain 'Connection' header with value 'Upgrade'");
        }
        if (!serverHeaders.containsKey("Sec-WebSocket-Accept")) {
            throw new HttpUpgradeException("Server response should contain 'Sec-WebSocket-Accept' header");
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            String expectedAcceptHeaderValue = new String(Base64.getEncoder().encode(md.digest((nonce + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes())));
            if (!((String)serverHeaders.get("Sec-WebSocket-Accept")).equals(expectedAcceptHeaderValue)) {
                throw new HttpUpgradeException("Server response header 'Sec-WebSocket-Accept' has incorrect value.");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return serverHeaders;
    }

    private void checkHttpStatus(String statusLine, int expectedStatusCode) throws HttpException {
        Matcher matcher = HTTP_STATUS_PATTERN.matcher(statusLine);
        if (matcher.find()) {
            int statusCode = Integer.parseInt(matcher.group(1));
            if (statusCode != expectedStatusCode) {
                throw new HttpUpgradeException("Got unexpected status " + statusCode + " with statusLine:" + statusLine, statusCode);
            }
        } else {
            throw new HttpProtocolException("Invalid status line");
        }
    }

    private String getLowerCase(String value) {
        if (value != null) {
            return value.toLowerCase();
        }
        return null;
    }

    private URL correctUrl(URL wsURL) {
        if (wsURL.getPath().startsWith("/")) {
            return wsURL;
        }
        try {
            Object path = wsURL.getFile();
            if (!((String)path).trim().startsWith("/")) {
                path = "/" + ((String)path).trim();
            }
            if (wsURL.getRef() != null) {
                path = (String)path + "#" + wsURL.getRef();
            }
            return new URL(wsURL.getProtocol(), wsURL.getHost(), wsURL.getPort(), (String)path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        UPGRADE_HEADERS.addAll(Arrays.asList("Host", "Upgrade", "Connection", "Sec-WebSocket-Key", "Sec-WebSocket-Version"));
    }

    public static class HttpResult {
        public Map<String, String> responseHeaders;
        public int requestSize;
        public int responseSize;

        public HttpResult() {
            this.responseHeaders = Collections.emptyMap();
        }

        public HttpResult(Map<String, String> responseHeaders, int requestSize, int responseSize) {
            this.responseHeaders = responseHeaders;
            this.requestSize = requestSize;
            this.responseSize = responseSize;
        }
    }

    static enum WebSocketState {
        CLOSED,
        CLOSED_CLIENT,
        CLOSED_SERVER,
        CONNECTED,
        CONNECTING;


        public boolean isClosing() {
            return this == CLOSED_CLIENT || this == CLOSED_SERVER;
        }
    }
}

