/*
 * Decompiled with CFR 0.152.
 */
package in.kvm.jmeter.listeners;

import in.kvm.jmeter.listeners.AbstractMysqlMetricsSender;
import in.kvm.jmeter.listeners.MysqlMetricsSender;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GenericMysqlMetricsSender
extends AbstractMysqlMetricsSender {
    private static final Logger log = LoggerFactory.getLogger(GenericMysqlMetricsSender.class);
    private final Object lock = new Object();
    private List<MysqlMetricsSender.MetricTuple> metrics = new ArrayList<MysqlMetricsSender.MetricTuple>();
    private Future<Integer> lastRequest;
    private String JDBC_DRIVER = "com.mysql.jdbc.Driver";
    private String DB_URL = "jdbc:mysql://%s:%s/";
    private Connection connection = null;
    private Statement statement;
    private PreparedStatement eventsPreparedStatement;
    private String DB_CREATE_SQL = "CREATE DATABASE %s";
    private String TABLE_CREATE_EVENTS_SQL = "CREATE TABLE IF NOT EXISTS  %s.events (  `time` timestamp NOT NULL,  `application` varchar(30),  `text` varchar(40),  `title` varchar(20))";
    private String TABLE_CREATE_JMETER_SQL = "CREATE TABLE IF NOT EXISTS %s.jmeter (  `tStamp` timestamp NOT NULL,  `application` varchar(30),  `avg` decimal(7,3),  `count` int(11),  `countError` int(11),  `endedT` int(11),  `hit` int(11),  `max` decimal(7,3),  `maxAT` decimal(7,3),  `meanAT` decimal(7,3),  `min` decimal(7,3),  `minAT` decimal(7,3),  `pct90` decimal(7,3),  `pct95` decimal(7,3),  `pct99` decimal(7,3),  `startedT` int(11),  `status`varchar(5),  `transaction` varchar(256),  `responsecode` varchar(256),  `responsemessage` varchar(512))";
    private String INSERT_EVENTS_SQL = "INSERT INTO %s.events(time, application, text, title) VALUES(?,?,?,?)";
    private String INSERT_TRANSACTIONS_SQL = "INSERT INTO %s.jmeter ( %s ) VALUES ( %s )";

    GenericMysqlMetricsSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetric(String mesurement, String tag, String field) {
        Object object = this.lock;
        synchronized (object) {
            this.metrics.add(new MysqlMetricsSender.MetricTuple(mesurement, tag, field, System.currentTimeMillis()));
        }
    }

    @Override
    public void setup(String mysqlHost, String mysqlPort, String mysqlSchema, String userName, String password) {
        boolean schemaExists = false;
        try {
            Class.forName(this.JDBC_DRIVER);
            this.connection = DriverManager.getConnection(String.format(this.DB_URL, mysqlHost, mysqlPort), userName, password);
            ResultSet resultSet = this.connection.getMetaData().getCatalogs();
            log.debug("**List of available Schemas**");
            while (resultSet.next()) {
                String databaseName = resultSet.getString(1);
                log.debug(databaseName);
                if (!databaseName.equalsIgnoreCase(mysqlSchema)) continue;
                log.debug("Database already exists");
                schemaExists = true;
                break;
            }
            resultSet.close();
            if (!schemaExists) {
                this.statement = this.connection.createStatement();
                this.statement.executeUpdate(String.format(this.DB_CREATE_SQL, mysqlSchema));
                log.debug("Database created successfully..");
                this.statement.executeUpdate(String.format(this.TABLE_CREATE_EVENTS_SQL, mysqlSchema));
                this.statement.executeUpdate(String.format(this.TABLE_CREATE_JMETER_SQL, mysqlSchema));
            }
            this.INSERT_EVENTS_SQL = String.format(this.INSERT_EVENTS_SQL, mysqlSchema);
            this.INSERT_TRANSACTIONS_SQL = String.format(this.INSERT_TRANSACTIONS_SQL, mysqlSchema, "%s", "%s");
            this.connection.setCatalog(mysqlSchema);
            log.debug("Catalog: " + this.connection.getCatalog());
        }
        catch (ClassNotFoundException e) {
            log.error("Class Not found: " + this.JDBC_DRIVER);
            e.printStackTrace();
        }
        catch (SQLException e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAndSendMetrics() {
        List<MysqlMetricsSender.MetricTuple> tempMetrics;
        Object object = this.lock;
        synchronized (object) {
            if (this.metrics.isEmpty()) {
                return;
            }
            tempMetrics = this.metrics;
            this.metrics = new ArrayList<MysqlMetricsSender.MetricTuple>(tempMetrics.size());
        }
        List<MysqlMetricsSender.MetricTuple> copyMetrics = tempMetrics;
        if (!copyMetrics.isEmpty()) {
            String[] parts;
            if (this.statement == null) {
                // empty if block
            }
            StringBuilder sb = new StringBuilder(copyMetrics.size() * 35);
            for (MysqlMetricsSender.MetricTuple metric : copyMetrics) {
                sb.append(metric.measurement).append(metric.tag).append(",").append(metric.field).append(",").append("tStamp=" + metric.timestamp).append("\n");
                log.debug(" >>> " + metric.tag + " : " + metric.field + " : " + metric.timestamp);
            }
            log.debug(">>>>>>>>>>>><<<<<<<<<<<");
            log.debug(sb.toString());
            log.debug(">>>>>>>>>>>><<<<<<<<<<<");
            for (String s : parts = sb.toString().split("\n")) {
                String[] internalParts;
                for (String ss : internalParts = s.split(",")) {
                    if (ss.equals("events")) {
                        this.writeEventsToDB(this.INSERT_EVENTS_SQL, internalParts);
                        continue;
                    }
                    if (!ss.equals("jmeter")) continue;
                    this.writeTransactionsToDB(internalParts);
                }
            }
        }
        copyMetrics.clear();
    }

    @Override
    public void destroy() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void writeTransactionsToDB(String[] parts) {
        log.debug("Writing Transactions to DB");
        StringBuilder keys = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (int i = 1; i < parts.length; ++i) {
            String[] part = parts[i].split("=");
            if (i != parts.length - 1) {
                keys.append(part[0] + ",");
                values.append(part[0].equalsIgnoreCase("application") | part[0].equalsIgnoreCase("status") | part[0].equalsIgnoreCase("responsecode") | part[0].equalsIgnoreCase("responsemessage") | part[0].equalsIgnoreCase("transaction") ? "'" + part[1] + "'," : part[1] + ",");
                continue;
            }
            keys.append(part[0]);
            values.append("'" + new Timestamp(Long.parseLong(part[1])) + "'");
        }
        try {
            StringBuilder query = new StringBuilder();
            query.append(String.format(this.INSERT_TRANSACTIONS_SQL, keys.toString(), values.toString()));
            log.debug("QUERY: " + query.toString());
            this.statement = this.connection.createStatement();
            int row = this.statement.executeUpdate(query.toString());
            log.debug("Inserted: " + row);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeEventsToDB(String query, String[] parts) {
        try {
            log.debug("Writing Events to DB");
            this.eventsPreparedStatement = this.connection.prepareStatement(query);
            this.eventsPreparedStatement.setTimestamp(1, new Timestamp(Long.parseLong(parts[4].split("=")[1])));
            this.eventsPreparedStatement.setString(2, parts[1].split("=")[1]);
            this.eventsPreparedStatement.setString(3, parts[3].split("=")[1]);
            this.eventsPreparedStatement.setString(4, parts[2].split("=")[1]);
            this.eventsPreparedStatement.execute();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

