/*
 * Decompiled with CFR 0.152.
 */
package in.kvm.jmeter.listeners;

import in.kvm.jmeter.listeners.AbstractMysqlMetricsSender;
import in.kvm.jmeter.listeners.GenericMysqlMetricsSender;
import in.kvm.jmeter.listeners.MysqlMetricsSender;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jmeter.visualizers.backend.SamplerMetric;
import org.apache.jmeter.visualizers.backend.UserMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlBackendListenerClient
extends AbstractBackendListenerClient
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MysqlBackendListenerClient.class);
    private ConcurrentHashMap<String, SamplerMetric> metricsPerSampler = new ConcurrentHashMap();
    private static final String DEFAULT_MEASUREMENT = "jmeter";
    private static final String EVENTS_FOR_ANNOTATION = "events";
    private static final String TAGS = ",tags=";
    private static final String TEXT = "text=\"";
    private static final long SEND_INTERVAL = 5L;
    private static final String SEPARATOR = ";";
    private static final int MAX_POOL_SIZE = 1;
    private static final String CUMULATED_METRICS = "all";
    private static final String TAG_OK = "ok";
    private static final String TAG_KO = "ko";
    private static final String TAG_ALL = "all";
    private static final String TAG_STATUS = ",status=";
    private static final String TAG_APPLICATION = ",application=";
    private static final String TAG_RESPONSE_CODE = ",responseCode=";
    private static final String TAG_RESPONSE_MESSAGE = ",responseMessage=";
    private static final String TAG_TRANSACTION = ",transaction=";
    private static final String METRIC_COUNT = "count=";
    private static final String METRIC_COUNT_ERROR = "countError=";
    private static final String METRIC_MIN = "min=";
    private static final String METRIC_MAX = "max=";
    private static final String METRIC_AVG = "avg=";
    private static final String METRIC_HIT = "hit=";
    private static final String METRIC_PCT_PREFIX = "pct";
    private static final String METRIC_MAX_ACTIVE_THREADS = "maxAT=";
    private static final String METRIC_MIN_ACTIVE_THREADS = "minAT=";
    private static final String METRIC_MEAN_ACTIVE_THREADS = "meanAT=";
    private static final String METRIC_STARTED_THREADS = "startedT=";
    private static final String METRIC_ENDED_THREADS = "endedT=";
    private String MysqlServer;
    private String MysqlPort;
    private String MysqlDatabaseName;
    private String MysqlUserName;
    private String MysqlPassword;
    private String application = "";
    private String measurement = "DEAFAULT_MEASUREMENT";
    private boolean summaryOnly;
    private String samplersRegex = "";
    private Map<String, Float> okPercentiles;
    private Map<String, Float> koPercentiles;
    private Map<String, Float> allPercentiles;
    private String testTitle;
    private String testTags;
    private Pattern samplersToFilter;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> timerHandle;
    private static final Object LOCK = new Object();
    private MysqlMetricsSender mysqlMetricsManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
        Object object = LOCK;
        synchronized (object) {
            UserMetric userMetrics = this.getUserMetrics();
            for (SampleResult sampleResult : sampleResults) {
                userMetrics.add(sampleResult);
                Matcher matcher = this.samplersToFilter.matcher(sampleResult.getSampleLabel());
                if (!this.summaryOnly && matcher.find()) {
                    SamplerMetric samplerMetric = this.getSamplerMetricMysqldb(sampleResult.getSampleLabel());
                    samplerMetric.add(sampleResult);
                }
                SamplerMetric cumulatedMetrics = this.getSamplerMetricMysqldb("all");
                cumulatedMetrics.add(sampleResult);
            }
        }
    }

    protected SamplerMetric getSamplerMetricMysqldb(String sampleLabel) {
        SamplerMetric oldValue;
        SamplerMetric samplerMetric = this.metricsPerSampler.get(sampleLabel);
        if (samplerMetric == null && (oldValue = this.metricsPerSampler.putIfAbsent(sampleLabel, samplerMetric = new SamplerMetric())) != null) {
            samplerMetric = oldValue;
        }
        return samplerMetric;
    }

    private Map<String, SamplerMetric> getMetricsMysqldbPerSampler() {
        return this.metricsPerSampler;
    }

    private void addMetrics(String transaction, SamplerMetric metric) {
        this.addMetric(transaction, metric.getTotal(), false, "all", metric.getAllMean(), metric.getAllMinTime(), metric.getAllMaxTime(), this.allPercentiles.values(), arg_0 -> ((SamplerMetric)metric).getAllPercentile(arg_0));
        this.addMetric(transaction, metric.getSuccesses(), false, TAG_OK, metric.getOkMean(), metric.getOkMinTime(), metric.getOkMaxTime(), this.okPercentiles.values(), arg_0 -> ((SamplerMetric)metric).getOkPercentile(arg_0));
        this.addMetric(transaction, metric.getFailures(), true, TAG_KO, metric.getKoMean(), metric.getKoMinTime(), metric.getKoMaxTime(), this.koPercentiles.values(), arg_0 -> ((SamplerMetric)metric).getKoPercentile(arg_0));
        metric.getErrors().forEach((error, count) -> this.addErrorMetric(transaction, error.getResponseCode(), error.getResponseMessage(), count.intValue()));
    }

    private void addMetric(String transaction, int count, boolean includeResponseCode, String status, double mean, double minTime, double maxTime, Collection<Float> pcts, PercentileProvider percentileProvider) {
        if (count > 0) {
            StringBuilder tag = new StringBuilder(70);
            tag.append(TAG_APPLICATION).append(this.application);
            tag.append(TAG_STATUS).append(status);
            tag.append(TAG_TRANSACTION).append(transaction);
            StringBuilder field = new StringBuilder(80);
            field.append(METRIC_COUNT).append(count);
            if (!Double.isNaN(mean)) {
                field.append(",").append(METRIC_AVG).append(mean);
            }
            if (!Double.isNaN(minTime)) {
                field.append(",").append(METRIC_MIN).append(minTime);
            }
            if (!Double.isNaN(maxTime)) {
                field.append(",").append(METRIC_MAX).append(maxTime);
            }
            for (Float pct : pcts) {
                field.append(",").append(METRIC_PCT_PREFIX).append(pct.intValue()).append("=").append(percentileProvider.getPercentileValue(pct.floatValue()));
            }
            this.mysqlMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
        }
    }

    private void addErrorMetric(String transaction, String responseCode, String responseMessage, long count) {
        if (count > 0L) {
            StringBuilder tag = new StringBuilder(70);
            tag.append(TAG_APPLICATION).append(this.application);
            tag.append(TAG_TRANSACTION).append(transaction);
            tag.append(TAG_RESPONSE_CODE).append(AbstractMysqlMetricsSender.tagToStringValue(responseCode));
            tag.append(TAG_RESPONSE_MESSAGE).append(AbstractMysqlMetricsSender.tagToStringValue(responseMessage));
            StringBuilder field = new StringBuilder(30);
            field.append(METRIC_COUNT).append(count);
            this.mysqlMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
        }
    }

    private void addCumulatedMetrics(SamplerMetric metric) {
        int total = metric.getTotal();
        if (total > 0) {
            StringBuilder tag = new StringBuilder(70);
            StringBuilder field = new StringBuilder(100);
            Collection<Float> pcts = this.allPercentiles.values();
            tag.append(TAG_APPLICATION).append(this.application);
            tag.append(TAG_TRANSACTION).append("all");
            tag.append(TAG_STATUS).append("all");
            field.append(METRIC_COUNT).append(total);
            field.append(",").append(METRIC_COUNT_ERROR).append(metric.getFailures());
            if (!Double.isNaN(metric.getOkMean())) {
                field.append(",").append(METRIC_AVG).append(Double.toString(metric.getOkMean()));
            }
            if (!Double.isNaN(metric.getOkMinTime())) {
                field.append(",").append(METRIC_MIN).append(Double.toString(metric.getOkMinTime()));
            }
            if (!Double.isNaN(metric.getOkMaxTime())) {
                field.append(",").append(METRIC_MAX).append(Double.toString(metric.getOkMaxTime()));
            }
            field.append(",").append(METRIC_HIT).append(metric.getHits());
            for (Float pct : pcts) {
                field.append(",").append(METRIC_PCT_PREFIX).append(pct.intValue()).append("=").append(Double.toString(metric.getAllPercentile((double)pct.floatValue())));
            }
            this.mysqlMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
        }
    }

    private void addAnnotation(boolean startOrEnd) {
        this.mysqlMetricsManager.addMetric(EVENTS_FOR_ANNOTATION, TAG_APPLICATION + this.application + ",title=ApacheJMeter" + (StringUtils.isNotEmpty((CharSequence)this.testTags) ? TAGS + this.testTags : ""), TEXT + AbstractMysqlMetricsSender.fieldToStringValue(this.testTitle + (startOrEnd ? " started" : " ended")) + "\"");
    }

    @Override
    public void run() {
        this.sendMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMetrics() {
        Object object = LOCK;
        synchronized (object) {
            for (Map.Entry<String, SamplerMetric> entry : this.getMetricsMysqldbPerSampler().entrySet()) {
                SamplerMetric metric = entry.getValue();
                if (entry.getKey().equals("all")) {
                    this.addCumulatedMetrics(metric);
                } else {
                    this.addMetrics(AbstractMysqlMetricsSender.tagToStringValue(entry.getKey()), metric);
                }
                metric.resetForTimeInterval();
            }
        }
        UserMetric userMetrics = this.getUserMetrics();
        StringBuilder tag = new StringBuilder(60);
        tag.append(TAG_APPLICATION).append(this.application);
        tag.append(TAG_TRANSACTION).append("internal");
        StringBuilder field = new StringBuilder(80);
        field.append(METRIC_MIN_ACTIVE_THREADS).append(userMetrics.getMinActiveThreads()).append(",");
        field.append(METRIC_MAX_ACTIVE_THREADS).append(userMetrics.getMaxActiveThreads()).append(",");
        field.append(METRIC_MEAN_ACTIVE_THREADS).append(userMetrics.getMeanActiveThreads()).append(",");
        field.append(METRIC_STARTED_THREADS).append(userMetrics.getStartedThreads()).append(",");
        field.append(METRIC_ENDED_THREADS).append(userMetrics.getFinishedThreads());
        this.mysqlMetricsManager.addMetric(this.measurement, tag.toString(), field.toString());
        this.mysqlMetricsManager.writeAndSendMetrics();
    }

    public void setupTest(BackendListenerContext context) throws Exception {
        String MysqlMetricsSender2 = context.getParameter("MYSQLMetricsSender");
        this.MysqlServer = context.getParameter("MYSQLServer");
        this.MysqlPort = context.getParameter("MYSQLPort");
        this.MysqlDatabaseName = context.getParameter("MYSQLDatabaseName");
        this.MysqlUserName = context.getParameter("MYSQLUsername");
        this.MysqlPassword = context.getParameter("MYSQLPassword");
        this.summaryOnly = context.getBooleanParameter("summaryOnly", false);
        this.samplersRegex = context.getParameter("samplersRegex", "");
        this.application = AbstractMysqlMetricsSender.tagToStringValue(context.getParameter("application", ""));
        this.measurement = AbstractMysqlMetricsSender.tagToStringValue(context.getParameter("measurement", DEFAULT_MEASUREMENT));
        this.testTitle = context.getParameter("testTitle", "Test");
        this.testTags = AbstractMysqlMetricsSender.tagToStringValue(context.getParameter("eventTags", ""));
        String percentilesAsString = context.getParameter("percentiles", "");
        String[] percentilesStringArray = percentilesAsString.split(SEPARATOR);
        this.okPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.koPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.allPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        DecimalFormat format = new DecimalFormat("0.##");
        for (int i = 0; i < percentilesStringArray.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)percentilesStringArray[i].trim())) continue;
            try {
                Float percentileValue = Float.valueOf(percentilesStringArray[i].trim());
                this.okPercentiles.put(AbstractMysqlMetricsSender.tagToStringValue(format.format(percentileValue)), percentileValue);
                this.koPercentiles.put(AbstractMysqlMetricsSender.tagToStringValue(format.format(percentileValue)), percentileValue);
                this.allPercentiles.put(AbstractMysqlMetricsSender.tagToStringValue(format.format(percentileValue)), percentileValue);
                continue;
            }
            catch (Exception e) {
                log.error("Error parsing percentile: '{}'", (Object)percentilesStringArray[i], (Object)e);
            }
        }
        Class<?> clazz = Class.forName(MysqlMetricsSender2);
        this.mysqlMetricsManager = (GenericMysqlMetricsSender)clazz.newInstance();
        this.mysqlMetricsManager.setup(this.MysqlServer, this.MysqlPort, this.MysqlDatabaseName, this.MysqlUserName, this.MysqlPassword);
        this.samplersToFilter = Pattern.compile(this.samplersRegex);
        this.addAnnotation(true);
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.timerHandle = this.scheduler.scheduleAtFixedRate(this, 0L, 5L, TimeUnit.SECONDS);
    }

    public void teardownTest(BackendListenerContext context) throws Exception {
        boolean cancelState = this.timerHandle.cancel(false);
        log.debug("Canceled state: {}", (Object)cancelState);
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Error waiting for end of scheduler");
            Thread.currentThread().interrupt();
        }
        this.addAnnotation(false);
        log.info("Sending last metrics");
        this.sendMetrics();
        this.mysqlMetricsManager.destroy();
        super.teardownTest(context);
    }

    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        arguments.addArgument("MYSQLMetricsSender", "in.kvm.jmeter.listeners.GenericMysqlMetricsSender");
        arguments.addArgument("MYSQLServer", "127.0.0.1");
        arguments.addArgument("MYSQLPort", "3306");
        arguments.addArgument("MYSQLUsername", "");
        arguments.addArgument("MYSQLPassword", "");
        arguments.addArgument("MYSQLDatabaseName", "jmeterdb");
        arguments.addArgument("application", "jmeterApplication");
        arguments.addArgument("measurement", DEFAULT_MEASUREMENT);
        arguments.addArgument("summaryOnly", "false");
        arguments.addArgument("samplersRegex", ".*");
        arguments.addArgument("percentiles", "99;95;90");
        arguments.addArgument("testTitle", "Test name");
        return arguments;
    }

    @FunctionalInterface
    private static interface PercentileProvider {
        public double getPercentileValue(double var1);
    }
}

