/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.colors;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kg.apc.charting.ColorsDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPalette
implements ColorsDispatcher {
    List<Color> customPalette = new ArrayList<Color>(16);
    private static final Logger log = LoggerFactory.getLogger(CustomPalette.class);
    int i = 0;

    public CustomPalette(String options) {
        this.buildCustomPalette(options);
        this.reset();
    }

    private void buildCustomPalette(String palette) {
        try {
            String[] colors = palette.split(",");
            if (palette.trim().length() == 0 || colors.length == 0) {
                log.warn("Empty palette, using static palette");
                this.useStaticPalette();
                return;
            }
            for (String color : colors) {
                try {
                    Color c = new Color(Integer.parseInt(color, 16));
                    log.debug("Adding to custom palette color: " + c);
                    this.customPalette.add(c);
                }
                catch (Exception e) {
                    log.warn("Exception " + e.getClass().getName() + " adding color: " + color + " ...skipping");
                }
            }
        }
        catch (Exception e) {
            log.error("Error building custom palette, using static palette: " + e.getClass().getName() + ": " + e.getMessage());
            this.useStaticPalette();
        }
    }

    private void useStaticPalette() {
        this.customPalette.add(new Color(11544359));
        this.customPalette.add(new Color(11558439));
        this.customPalette.add(new Color(11572775));
        this.customPalette.add(new Color(9678887));
        this.customPalette.add(new Color(6008871));
        this.customPalette.add(new Color(2601002));
        this.customPalette.add(new Color(2601058));
        this.customPalette.add(new Color(2601113));
        this.customPalette.add(new Color(2592944));
        this.customPalette.add(new Color(2578608));
        this.customPalette.add(new Color(2959280));
        this.customPalette.add(new Color(6629296));
        this.customPalette.add(new Color(10233776));
        this.customPalette.add(new Color(0));
        this.customPalette.add(new Color(0x333333));
        this.customPalette.add(new Color(0x666666));
    }

    @Override
    public void reset() {
        this.i = 0;
    }

    @Override
    public Color getNextColor() {
        if (this.i + 1 > this.customPalette.size()) {
            this.reset();
            return this.getNextColor();
        }
        Color c = this.customPalette.get(this.i);
        log.debug("Custom color c next: " + c);
        ++this.i;
        return c;
    }
}

