const notice = "ArrayVector is deprecated and will be removed in Grafana 11. Please use plain arrays for field.values.";
let notified = false;
class ArrayVector extends Array {
  get buffer() {
    return this;
  }
  set buffer(values) {
    this.length = 0;
    const len = values == null ? void 0 : values.length;
    if (len) {
      let chonkSize = 65e3;
      let numChonks = Math.ceil(len / chonkSize);
      for (let chonkIdx = 0; chonkIdx < numChonks; chonkIdx++) {
        this.push.apply(this, values.slice(chonkIdx * chonkSize, (chonkIdx + 1) * chonkSize));
      }
    }
  }
  /**
   * This any type is here to make the change type changes in v10 non breaking for plugins.
   * Before you could technically assign field.values any typed ArrayVector no matter what the Field<T> T type was.
   */
  constructor(buffer) {
    super();
    this.buffer = buffer != null ? buffer : [];
    if (!notified) {
      console.warn(notice);
      notified = true;
    }
  }
  toJSON() {
    return [...this];
  }
}

export { ArrayVector };
//# sourceMappingURL=ArrayVector.js.map
