import { makeArrayIndexableVector } from '../types/vector.js';
import { FunctionalVector } from './FunctionalVector.js';
import { vectorToArray } from './vectorToArray.js';

class SortedVector extends FunctionalVector {
  constructor(source, order) {
    super();
    this.source = source;
    this.order = order;
    return makeArrayIndexableVector(this);
  }
  get length() {
    return this.source.length;
  }
  get(index) {
    return this.source.get(this.order[index]);
  }
  toArray() {
    return vectorToArray(this);
  }
  toJSON() {
    return vectorToArray(this);
  }
  getOrderArray() {
    return this.order;
  }
}

export { SortedVector };
//# sourceMappingURL=SortedVector.js.map
