import { faro, LogLevel } from '@grafana/faro-web-sdk';
export { LogLevel } from '@grafana/faro-web-sdk';
import { config } from '../config.js';

function logInfo(message, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushLog([message], {
      level: LogLevel.INFO,
      context: contexts
    });
  }
}
function logWarning(message, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushLog([message], {
      level: LogLevel.WARN,
      context: contexts
    });
  }
}
function logDebug(message, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushLog([message], {
      level: LogLevel.DEBUG,
      context: contexts
    });
  }
}
function logError(err, contexts) {
  if (config.grafanaJavascriptAgent.enabled) {
    faro.api.pushError(err, {
      context: contexts
    });
  }
}

export { logDebug, logError, logInfo, logWarning };
//# sourceMappingURL=logging.js.map
