import { useEffect } from 'react';

function useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef) {
  useEffect(() => {
    var _a;
    if (variableSizeListScrollbarRef.current && tableDivRef.current) {
      const listVerticalScrollbarHTML = variableSizeListScrollbarRef.current.querySelector(".track-vertical");
      const tableScrollbarView = tableDivRef.current.firstChild;
      if (tableScrollbarView && listVerticalScrollbarHTML) {
        listVerticalScrollbarHTML.remove();
        if (tableScrollbarView instanceof HTMLElement) {
          (_a = tableScrollbarView.querySelector(":scope > .track-vertical")) == null ? void 0 : _a.remove();
          tableScrollbarView.append(listVerticalScrollbarHTML);
        }
      }
    }
  });
}
function useResetVariableListSizeCache(extendedState, listRef, data) {
  useEffect(() => {
    var _a;
    if (extendedState.lastExpandedIndex !== void 0) {
      let resetIndex = extendedState.lastExpandedIndex;
      const expandedIndexes = Object.keys(extendedState.expanded);
      if (expandedIndexes.length > 0) {
        const lowestExpandedIndex = parseInt(expandedIndexes[0], 10);
        if (!isNaN(lowestExpandedIndex)) {
          resetIndex = Math.min(resetIndex, lowestExpandedIndex);
        }
      }
      const index = extendedState.pageIndex === 0 ? resetIndex - 1 : resetIndex - extendedState.pageIndex - extendedState.pageIndex * extendedState.pageSize;
      (_a = listRef.current) == null ? void 0 : _a.resetAfterIndex(Math.max(index, 0));
      return;
    }
  }, [
    extendedState.lastExpandedIndex,
    extendedState.toggleRowExpandedCounter,
    extendedState.pageIndex,
    extendedState.pageSize,
    listRef,
    data,
    extendedState.expanded
  ]);
}

export { useFixScrollbarContainer, useResetVariableListSizeCache };
//# sourceMappingURL=hooks.js.map
