import { css } from '@emotion/css';
import React__default, { useRef, useReducer, useLayoutEffect } from 'react';
import { createPortal } from 'react-dom';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.js';
import { CloseButton } from './CloseButton.js';

var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
function mergeState(prevState, nextState) {
  return __spreadProps(__spreadValues(__spreadValues({}, prevState), nextState), {
    style: __spreadValues(__spreadValues({}, prevState.style), nextState.style)
  });
}
const INITIAL_STATE = {
  style: { transform: "", pointerEvents: "none" },
  isHovering: false,
  isPinned: false,
  contents: null,
  plot: null,
  dismiss: () => {
  }
};
const MIN_ZOOM_DIST = 5;
const maybeZoomAction = (e) => e != null && !e.ctrlKey && !e.metaKey;
const TooltipPlugin2 = ({ config, hoverMode, render, clientZoom = false, queryZoom }) => {
  const domRef = useRef(null);
  const [{ plot, isHovering, isPinned, contents, style, dismiss }, setState] = useReducer(mergeState, INITIAL_STATE);
  const sizeRef = useRef();
  const styles = useStyles2(getStyles);
  const renderRef = useRef(render);
  renderRef.current = render;
  useLayoutEffect(() => {
    sizeRef.current = {
      width: 0,
      height: 0,
      observer: new ResizeObserver((entries) => {
        var _a;
        let size = sizeRef.current;
        for (const entry of entries) {
          if (((_a = entry.borderBoxSize) == null ? void 0 : _a.length) > 0) {
            size.width = entry.borderBoxSize[0].inlineSize;
            size.height = entry.borderBoxSize[0].blockSize;
          } else {
            size.width = entry.contentRect.width;
            size.height = entry.contentRect.height;
          }
        }
      })
    };
    let yZoomed = false;
    let yDrag = false;
    let _plot = plot;
    let _isHovering = isHovering;
    let _isPinned = isPinned;
    let _style = style;
    let offsetX = 0;
    let offsetY = 0;
    let htmlEl = document.documentElement;
    let winWidth = htmlEl.clientWidth - 16;
    let winHeight = htmlEl.clientHeight - 16;
    window.addEventListener("resize", (e) => {
      winWidth = htmlEl.clientWidth - 5;
      winHeight = htmlEl.clientHeight - 5;
    });
    let seriesIdxs = plot == null ? void 0 : plot.cursor.idxs.slice();
    let closestSeriesIdx = null;
    let pendingRender = false;
    let pendingPinned = false;
    const scheduleRender = (setPinned = false) => {
      if (!pendingRender) {
        if (!_isHovering) {
          setTimeout(_render, 100);
        } else {
          queueMicrotask(_render);
        }
        pendingRender = true;
      }
      if (setPinned) {
        pendingPinned = true;
      }
    };
    const downEventOutside = (e) => {
      let isOutside = e.target.closest(`.${styles.tooltipWrapper}`) !== domRef.current;
      if (isOutside) {
        dismiss2();
      }
    };
    const _render = () => {
      var _a, _b;
      pendingRender = false;
      if (pendingPinned) {
        _style = { pointerEvents: _isPinned ? "all" : "none" };
        (_b = (_a = domRef.current) == null ? void 0 : _a.closest(".react-grid-item")) == null ? void 0 : _b.classList.toggle("context-menu-open", _isPinned);
        _plot.cursor._lock = _isPinned;
        if (_isPinned) {
          document.addEventListener("mousedown", downEventOutside, true);
          document.addEventListener("keydown", downEventOutside, true);
        } else {
          document.removeEventListener("mousedown", downEventOutside, true);
          document.removeEventListener("keydown", downEventOutside, true);
        }
        pendingPinned = false;
      }
      let state = {
        style: _style,
        isPinned: _isPinned,
        isHovering: _isHovering,
        contents: _isHovering ? renderRef.current(_plot, seriesIdxs, closestSeriesIdx, _isPinned, dismiss2) : null,
        dismiss: dismiss2
      };
      setState(state);
    };
    const dismiss2 = () => {
      _isPinned = false;
      _isHovering = false;
      _plot.setCursor({ left: -10, top: -10 });
      scheduleRender(true);
    };
    config.addHook("init", (u) => {
      setState({ plot: _plot = u });
      if (clientZoom) {
        u.over.addEventListener(
          "mousedown",
          (e) => {
            if (!maybeZoomAction(e)) {
              return;
            }
            if (e.button === 0 && e.shiftKey) {
              yDrag = true;
              u.cursor.drag.x = false;
              u.cursor.drag.y = true;
              let onUp = (e2) => {
                u.cursor.drag.x = true;
                u.cursor.drag.y = false;
                document.removeEventListener("mouseup", onUp, true);
              };
              document.addEventListener("mouseup", onUp, true);
            }
          },
          true
        );
      }
      u.over.addEventListener("click", (e) => {
        if (_isHovering && closestSeriesIdx != null && !_isPinned && e.target === u.over) {
          _isPinned = true;
          scheduleRender(true);
        }
      });
    });
    config.addHook("setSelect", (u) => {
      if (clientZoom || queryZoom != null) {
        if (maybeZoomAction(u.cursor.event)) {
          if (clientZoom && yDrag) {
            if (u.select.height >= MIN_ZOOM_DIST) {
              for (let key in u.scales) {
                if (key !== "x") {
                  const maxY = u.posToVal(u.select.top, key);
                  const minY = u.posToVal(u.select.top + u.select.height, key);
                  u.setScale(key, { min: minY, max: maxY });
                }
              }
              yZoomed = true;
            }
            yDrag = false;
          } else if (queryZoom != null) {
            if (u.select.width >= MIN_ZOOM_DIST) {
              const minX = u.posToVal(u.select.left, "x");
              const maxX = u.posToVal(u.select.left + u.select.width, "x");
              queryZoom({ from: minX, to: maxX });
              yZoomed = false;
            }
          }
        }
      }
      u.setSelect({ left: 0, width: 0, top: 0, height: 0 }, false);
    });
    if (clientZoom || queryZoom != null) {
      config.setCursor({
        bind: {
          dblclick: (u) => () => {
            if (!maybeZoomAction(u.cursor.event)) {
              return null;
            }
            if (clientZoom && yZoomed) {
              for (let key in u.scales) {
                if (key !== "x") {
                  u.setScale(key, { min: null, max: null });
                }
              }
              yZoomed = false;
            } else if (queryZoom != null) {
              let xScale = u.scales.x;
              const frTs = xScale.min;
              const toTs = xScale.max;
              const pad = (toTs - frTs) / 2;
              queryZoom({ from: frTs - pad, to: toTs + pad });
            }
            return null;
          }
        }
      });
    }
    config.addHook("setData", (u) => {
      yZoomed = false;
      yDrag = false;
    });
    config.addHook("setLegend", (u) => {
      seriesIdxs = _plot == null ? void 0 : _plot.cursor.idxs.slice();
      let hoveredSeriesIdx = seriesIdxs.findIndex((v, i) => i > 0 && v != null);
      let _isHoveringNow = hoveredSeriesIdx !== -1;
      if (hoverMode === 2 /* xyOne */) {
        closestSeriesIdx = hoveredSeriesIdx;
      }
      if (_isHoveringNow) {
        if (!_isHovering) {
          _isHovering = true;
        }
      } else {
        if (_isHovering) {
          _isHovering = false;
        }
      }
      scheduleRender();
    });
    config.addHook("setSeries", (u, seriesIdx) => {
      closestSeriesIdx = seriesIdx;
      scheduleRender();
    });
    config.addHook("setCursor", (u) => {
      let { left = -10, top = -10 } = u.cursor;
      if (left >= 0 || top >= 0) {
        let { width, height } = sizeRef.current;
        let clientX = u.rect.left + left;
        let clientY = u.rect.top + top;
        if (offsetY) {
          if (clientY + height < winHeight || clientY - height < 0) {
            offsetY = 0;
          } else if (offsetY !== -height) {
            offsetY = -height;
          }
        } else {
          if (clientY + height > winHeight && clientY - height >= 0) {
            offsetY = -height;
          }
        }
        if (offsetX) {
          if (clientX + width < winWidth || clientX - width < 0) {
            offsetX = 0;
          } else if (offsetX !== -width) {
            offsetX = -width;
          }
        } else {
          if (clientX + width > winWidth && clientX - width >= 0) {
            offsetX = -width;
          }
        }
        const shiftX = offsetX !== 0 ? "translateX(-100%)" : "";
        const shiftY = offsetY !== 0 ? "translateY(-100%)" : "";
        const transform = `${shiftX} translateX(${left}px) ${shiftY} translateY(${top}px)`;
        if (_isHovering) {
          if (domRef.current != null) {
            domRef.current.style.transform = transform;
          } else {
            _style.transform = transform;
            scheduleRender();
          }
        }
      }
    });
  }, [config]);
  useLayoutEffect(() => {
    const size = sizeRef.current;
    if (domRef.current != null) {
      size.observer.observe(domRef.current);
    }
  }, [domRef.current]);
  if (plot && isHovering) {
    return createPortal(
      /* @__PURE__ */ React__default.createElement("div", { className: styles.tooltipWrapper, style, ref: domRef }, isPinned && /* @__PURE__ */ React__default.createElement(CloseButton, { onClick: dismiss }), contents),
      plot.over
    );
  }
  return null;
};
const getStyles = (theme) => ({
  tooltipWrapper: css({
    top: 0,
    left: 0,
    zIndex: theme.zIndex.tooltip,
    whiteSpace: "pre",
    borderRadius: theme.shape.radius.default,
    position: "absolute",
    background: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    boxShadow: `0 4px 8px ${theme.colors.background.primary}`,
    userSelect: "text"
  })
});

export { TooltipPlugin2 };
//# sourceMappingURL=TooltipPlugin2.js.map
